/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.ws;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import br.com.centralit.batch.ObtemInventario;
import br.com.centralit.bean.InventoryConfig;
import br.com.centralit.util.Assert;
import br.com.centralit.util.Enumerados.TipoInventario;

@Stateless
@Path("/ws")
public class InventoryWS {

	private static final String APPLICATION_JSON = MediaType.APPLICATION_JSON;
	private static final String APPLICATION_TEXT_PLAIN = MediaType.TEXT_PLAIN;

	public static String cronDoInventario;

	@Inject
	private IGerenteTarefas gerenteTarefas;

	@PUT
	@Path("/obterInventario")
	@Produces(APPLICATION_JSON)
	@Consumes(APPLICATION_JSON)
	public Response realizarInventario(final InventoryConfig config) {
		Assert.notNull(config, "Configuration info for inventory must not be null.");
		if (config != null) {
			final ObtemInventario obtemInventario = new ObtemInventario(config, TipoInventario.DEMANDA);
			obtemInventario.run();
		}
		return Response.status(Status.OK).entity("Processo de inventário iniciado no Citsmart Inventory.").build();
	}

	@GET
	@Path("/verificarDisponibilidade")
	@Produces(APPLICATION_TEXT_PLAIN)
	public Response getJson() {
		return Response.status(Status.OK).entity("OK").build();
	}

	@GET
	@Path("/atualizarConfiguracaoInventory")
	@Produces(APPLICATION_TEXT_PLAIN)
	public Response atualizarConfiguracaoInventory() {
		gerenteTarefas.cancelarTimers();
		gerenteTarefas.sincronizarHorariosInventarioComWSCitsmart();

		return Response.status(Status.OK).entity("OK").build();
	}

}
