/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.config;

import br.gov.planejamento.dipla.protocolo.config.BrasilCidadaoConfig;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;

@Configuration
public class BrasilCidadaoConfig {
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    Random gerador = new Random();

    public String gerarUrlAutorizar() {
        this.disableSSLCertificateChecking();
        String url = this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_AUTORIZAR) + "?response_type=code&client_id=" + this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.CLIENT_ID) + "&redirect_uri=" + this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.REDIRECT_URI) + "&nonce=" + this.gerador.hashCode() + "&state=" + this.gerador.hashCode();
        return url;
    }

    public String gerarUrlToken() {
        String url = this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_TOKEN);
        return url;
    }

    public String gerarUrlDadosUsuarios(String token) {
        String url = this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_DADOS_USUARIO) + this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ESCOPO) + "?access_token=" + token;
        return url;
    }

    @Bean(name={"urlBrasilCidadao"})
    public UrlBrasilCidadao gerarUrlBrasilCidadao() {
        String url = this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_BRASIL_CIDADAO);
        return () -> url;
    }

    @Bean(name={"urlPrimeiroAcesso"})
    public UrlPrimeiroAcesso gerarUrlPrimeiroAcesso() {
        String url = this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_PRIMEIRO_ACESSO);
        return () -> url;
    }

    public String gerarRequisicaoAtributo(String code) {
        String reqAtr = "grant_type=authorization_code&code=" + code + "&redirect_uri=" + this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.REDIRECT_URI);
        return reqAtr;
    }

    public HttpHeaders gerarRequisicaoHeader() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.CLIENT_ID) + ":" + this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.CLIENT_SECRET)).getBytes()));
        return headers;
    }

    private void disableSSLCertificateChecking() {
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

