/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.config;

import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class MailConfig {
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    @Bean
    public JavaMailSender mailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SMTP_SERVER));
        mailSender.setPort(Integer.parseInt(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SMTP_PORT)));
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", (Object)false);
        props.put("mail.smtp.starttls.enable", (Object)false);
        props.put("mail.debug", (Object)false);
        props.put("mail.smtp.ssl.enable", "false");
        props.put("mail.smtp.ssl.trust", "*");
        props.put("mail.smtp.connectiontimeout", (Object)10000);
        mailSender.setJavaMailProperties(props);
        return mailSender;
    }
}

