/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.config;

import br.gov.planejamento.dipla.protocolo.thymeleaf.ProtocoloDialect;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.format.number.NumberStyleFormatter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableSpringDataWebSupport
@EnableAsync
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Bean
    public ProtocoloDialect protocoloDialect() {
        return new ProtocoloDialect();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    public void addFormatters(FormatterRegistry registry) {
        NumberStyleFormatter bigDecimalFormatter = new NumberStyleFormatter("#,##0.00");
        registry.addFormatterForFieldType(BigDecimal.class, (Formatter)bigDecimalFormatter);
        DateTimeFormatterRegistrar dateTimeFormatter = new DateTimeFormatterRegistrar();
        dateTimeFormatter.setDateFormatter(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        dateTimeFormatter.setTimeFormatter(DateTimeFormatter.ofPattern("HH:mm"));
        dateTimeFormatter.registerFormatters(registry);
    }
}

