/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.clamav.ClamavUtil;
import br.gov.planejamento.dipla.protocolo.controllers.sessions.ArquivosSession;
import br.gov.planejamento.dipla.protocolo.dto.ArquivoDTO;
import br.gov.planejamento.dipla.protocolo.entities.Arquivos;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.repositories.ArquivosRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorageRunnable;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UriUtils;

@RestController
@RequestMapping(value={"/arquivos"})
public class ArquivosController {
    @Autowired
    private ArquivoStorage arquivoStorage;
    @Autowired
    private ArquivosSession arquivosSession;
    @Autowired
    private ArquivosRepository arquivosRepository;
    @Autowired
    private ClamavUtil clamavUtil;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    @PostMapping
    public DeferredResult<ArquivoDTO> upload(MultipartFile ... files) throws InterruptedException {
        DeferredResult deferredResult = new DeferredResult();
        try {
            if (!this.clamavUtil.isClean(files[0].getBytes())) {
                throw new RuntimeException("PDF fora do padr\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel o recebimento.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("PDF fora do padr\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel o recebimento.", e);
        }
        Thread thread = new Thread((Runnable)new ArquivoStorageRunnable(files, deferredResult, this.arquivoStorage));
        thread.start();
        return deferredResult;
    }

    @GetMapping(value={"/{uuid}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<ArquivoDTO>> listarArquivos(@PathVariable String uuid) {
        return ResponseEntity.ok((Object)this.arquivosSession.obterArquivos(uuid));
    }

    @PostMapping(value={"/anexar"})
    @ResponseBody
    public ResponseEntity<?> anexar(@RequestBody ArquivoDTO arquivoDTO) {
        this.arquivosSession.adicionarArquivo(arquivoDTO.getUuid(), arquivoDTO);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/{uuid}"})
    @ResponseBody
    public ResponseEntity<?> excluir(@PathVariable String uuid, @RequestParam(name="nome") String nome) {
        this.arquivosSession.excluirArquivo(uuid, nome);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/protocolo"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<List<Arquivos>> obterArquivosProtocolo(@RequestParam(value="htr") String codigo, HttpServletRequest httpServletRequest) {
        Protocolo protocolo = new Protocolo();
        byte[] decodedBytes = Base64.getDecoder().decode(codigo);
        String decodedString = new String(decodedBytes);
        String[] parts = decodedString.split("\\|", -1);
        Long decodedLong = Long.parseLong(parts[1].toString());
        protocolo.setCodigo(decodedLong);
        List arquivosList = this.arquivosRepository.findByProtocolo(protocolo);
        arquivosList.forEach(arquivo -> {
            arquivo.getProtocolo().setArquivosList(null);
            arquivo.setStatus(protocolo.getStatus());
            if (!protocolo.isAprovado()) {
                File f = new File(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.STORAGE_PATH) + "/" + arquivo.getNome());
                if (f.exists()) {
                    try {
                        arquivo.setUrl(httpServletRequest.getContextPath() + "/arquivos/" + UriUtils.encode((String)arquivo.getNome(), (String)"UTF-8"));
                    }
                    catch (Exception e) {
                        arquivo.setUrl(httpServletRequest.getContextPath() + "/arquivos/arquivo-enviado-sei");
                    }
                } else {
                    arquivo.setUrl(httpServletRequest.getContextPath() + "/arquivos/arquivo-enviado-sei");
                }
            } else {
                arquivo.setUrl(httpServletRequest.getContextPath() + "/arquivos/arquivo-enviado-sei");
            }
        });
        return ResponseEntity.ok().body((Object)arquivosList);
    }

    @GetMapping(value={"/arquivo-enviado-sei"})
    public ModelAndView arquivoEnviadoSEI() {
        return new ModelAndView("protocolo/ArquivoJaEnviadoSEI");
    }

    @GetMapping(value={"/temp/{nome:.*}"})
    public byte[] recuperarFotoTemporaria(@PathVariable String nome) {
        return this.arquivoStorage.recuperarFotoTemporaria(nome);
    }

    @GetMapping(value={"/logos/{nome:.*}"})
    public byte[] recuperarLogo(@PathVariable String nome) {
        return this.arquivoStorage.recuperarLogo(nome);
    }

    @GetMapping(value={"/{nome:.*}"})
    public byte[] recuperar(@PathVariable String nome) {
        return this.arquivoStorage.recuperar(nome);
    }
}

