/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.controllers.page.PageWrapper;
import br.gov.planejamento.dipla.protocolo.entities.Classificacao;
import br.gov.planejamento.dipla.protocolo.entities.Configuracao;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEmail;
import br.gov.planejamento.dipla.protocolo.entities.Metadado;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.ClassificacaoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoEmailRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.filter.ConfiguracaoFilter;
import br.gov.planejamento.dipla.protocolo.services.ConfiguracaoEmailService;
import br.gov.planejamento.dipla.protocolo.services.ConfiguracaoService;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/configuracao"})
public class ConfiguracaoController {
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private ClassificacaoRepository classificacaoRepository;
    @Autowired
    private ConfiguracaoEmailRepository configuracaoEmailRepository;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ConfiguracaoEmailService configuracaoEmailService;
    @Autowired
    private Mailer mailer;
    private final int DEFAULT_PAGEABLE_SIZE = 10;

    @GetMapping(value={"/configuracaoClassificacao/{classificacao}"})
    public ModelAndView configuracao(@PathVariable(value="classificacao") String classificacao, ConfiguracaoFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("configuracao/ConfiguracaoAmbiente");
        filter.setClassificacao((Classificacao)this.classificacaoRepository.findByNome(classificacao).get());
        PageWrapper paginaWrapper = new PageWrapper(this.configuracaoRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/configuracaoEmail"})
    public ModelAndView configuracao(HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("configuracao/ConfiguracaoEmail");
        List configuracaoEmailList = this.configuracaoEmailRepository.findAll();
        mv.addObject("configuracoes", (Object)configuracaoEmailList);
        return mv;
    }

    @GetMapping(value={"/{codigo}"})
    public ModelAndView editar(@PathVariable(value="codigo") Configuracao configuracao) {
        ModelAndView mv = new ModelAndView("configuracao/EditarConfiguracao");
        mv.addObject((Object)configuracao);
        return mv;
    }

    @GetMapping(value={"/configuracaoEmail/{codigo}"})
    public ModelAndView editarEmail(@PathVariable(value="codigo") ConfiguracaoEmail configuracaoEmail) {
        ModelAndView mv = new ModelAndView("configuracao/EditarConfiguracaoEmail");
        List listMetadado = configuracaoEmail.getMetadados();
        mv.addObject((Object)configuracaoEmail);
        mv.addObject("metadados", this.retornarScript(listMetadado));
        return mv;
    }

    @PostMapping(value={"/editarConfiguracao/{codigo}"})
    public ModelAndView editarEditarConfiguracao(@Valid Configuracao configuracao, BindingResult result, RedirectAttributes attributes) {
        if (result.hasFieldErrors()) {
            return new ModelAndView("redirect:/");
        }
        this.configuracaoService.editar(configuracao);
        attributes.addFlashAttribute("mensagem", (Object)"Configura\u00e7\u00e3o editada com sucesso.");
        String url = "redirect:/configuracao/configuracaoClassificacao/" + ((Configuracao)this.configuracaoRepository.findByCodigo(configuracao.getCodigo()).get()).getClassificacao().getNome();
        ModelAndView mv = new ModelAndView(url);
        return mv;
    }

    @PostMapping(value={"/editarConfiguracaoEmail/{codigo}"})
    public ModelAndView editarEditarConfiguracaoEmail(@Valid ConfiguracaoEmail configuracaoEmail, BindingResult result, RedirectAttributes attributes) {
        if (result.hasFieldErrors()) {
            return new ModelAndView("redirect:/");
        }
        this.configuracaoEmailService.editar(configuracaoEmail);
        attributes.addFlashAttribute("mensagem", (Object)"Configura\u00e7\u00e3o editada com sucesso.");
        ModelAndView mv = new ModelAndView("redirect:/configuracao/configuracaoEmail");
        return mv;
    }

    public Object retornarScript(List<Metadado> metadados) {
        String retorno = "tinymce.init({ selector:'textarea#valor' ,\r\n        \t\tplugins: \"link\" , \r\n        \t\textended_valid_elements : 'span', \r\n        \t\tcustom_elements : 'span', \r\n        \t\ttoolbar: 'metadado | insert | undo redo |  formatselect | bold italic backcolor  | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat | help',\r\n        \t\tmenubar: false,\r\n        \t\t    content_css: [\r\n        \t\t    '//fonts.googleapis.com/css?family=Lato:300,300i,400,400i',\r\n        \t\t    '//www.tinymce.com/css/codepen.min.css'],\r\n        \t\t  \r\n        \t\tsetup: function(editor) {\r\n        \t\t    editor.addButton('metadado', {\r\n        \t\t      type: 'menubutton',\r\n        \t\t      text: 'Metadado',\r\n        \t\t      icon: false,\r\n        \t\t      menu: [ \r\n";
        Iterator<Metadado> i = metadados.iterator();
        while (i.hasNext()) {
            Metadado metadado = i.next();
            retorno = retorno + "        \t\t      \t{ \r\n        \t\t      \ttext: '" + metadado.getNome() + "', \r\n        \t\t      \tonclick: function() { \r\n        \t\t      \t\teditor.insertContent('<span>{$" + metadado.getNome() + "}</span>'); \r\n\t\t\t\t\t\t\t} \r\n";
            if (i.hasNext()) {
                retorno = retorno + "\t\t\t\t\t\t} ,\r\n";
                continue;
            }
            retorno = retorno + "\t\t\t\t\t\t} \r\n";
        }
        retorno = retorno + "        \t\t    ]}\t\t\t\t);\r\n        \t} \r\n        });";
        return retorno;
    }
}

