/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.config.BrasilCidadaoConfig;
import br.gov.planejamento.dipla.protocolo.dto.UsuarioBrasilCidadaoDto;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioBrasilCidadao;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.security.LoginAttemptService;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import br.gov.planejamento.dipla.protocolo.services.AutoCadastroService;
import br.gov.planejamento.dipla.protocolo.services.BrasilCidadaoService;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LoginController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private BrasilCidadaoConfig brasilCidadaoOpenIdConnectConfig;
    @Autowired
    private BrasilCidadaoService brasilCidadaoService;
    @Autowired
    LoginAttemptService loginAttemptService;
    @Autowired
    private AutoCadastroService autoCadastroService;
    @Autowired
    private UsuarioRepository usuarioRepository;
    private String msgErro = null;
    @Value(value="${versao}")
    private String buildVersion;

    @GetMapping(value={"/verificar-usuario"})
    public ModelAndView confirmarCadastro(@AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        List permissoes = this.usuarioRepository.permissoes(usuarioSistema.getUsuario());
        if (permissoes.contains("ROLE_BRASILCIDADAO") && !usuarioSistema.getLoginBrasilCidadao().booleanValue()) {
            usuarioSistema.eraseCredentials();
            return new ModelAndView("/login");
        }
        this.loginAttemptService.loginSucceeded(usuarioSistema.getUsername());
        return new ModelAndView("redirect:/");
    }

    @RequestMapping(value={"/login"})
    public ModelAndView login(@RequestParam(value="code", required=false) String code, @AuthenticationPrincipal User user, @RequestParam(value="logout", required=false) String logout, HttpServletRequest httpServletRequest) {
        this.msgErro = null;
        ModelAndView mv = new ModelAndView("/Login");
        mv.addObject("modalConfirmacaoBrasilCidadao", (Object)false);
        httpServletRequest.getSession().setAttribute("versao", (Object)this.buildVersion);
        if (code != null) {
            try {
                UsuarioBrasilCidadaoDto usuarioretorno = this.brasilCidadaoService.autenticarBrasilCidadao(code);
                if (usuarioretorno != null) {
                    Optional usuarioBrasilCidadao = this.usuarioRepository.buscarBrasilCidadao(usuarioretorno.getCpf());
                    Optional usuarioEmailExistente = this.usuarioRepository.findByEmail(usuarioretorno.getEmail());
                    String baseUrl = String.format("%s://%s:%d/protocolo", httpServletRequest.getScheme(), httpServletRequest.getServerName(), httpServletRequest.getServerPort());
                    if (usuarioBrasilCidadao.isPresent() && ((UsuarioBrasilCidadao)usuarioBrasilCidadao.get()).getAtivo().booleanValue()) {
                        mv.setViewName("redirect:/enviar");
                        SecurityContextHolder.getContext().setAuthentication((Authentication)this.brasilCidadaoService.autenticarProtocolo(usuarioretorno));
                        if (usuarioEmailExistente.isPresent() && ((Usuario)usuarioEmailExistente.get()).getCodigo().equals(((UsuarioBrasilCidadao)usuarioBrasilCidadao.get()).getUsuario().getCodigo())) {
                            this.autoCadastroService.atualizarBrasilCidadao(usuarioretorno, (UsuarioBrasilCidadao)usuarioBrasilCidadao.get(), Boolean.valueOf(true));
                        } else {
                            this.autoCadastroService.atualizarBrasilCidadao(usuarioretorno, (UsuarioBrasilCidadao)usuarioBrasilCidadao.get(), Boolean.valueOf(false));
                            this.autoCadastroService.enviarConsiliacaoUsuario((UsuarioBrasilCidadao)usuarioBrasilCidadao.get(), usuarioretorno.getEmail(), baseUrl);
                            mv.addObject("modalConflito", (Object)true);
                            mv.addObject("email", (Object)usuarioretorno.getEmail());
                        }
                    } else if (usuarioBrasilCidadao.isPresent() && !((UsuarioBrasilCidadao)usuarioBrasilCidadao.get()).getAtivo().booleanValue()) {
                        if (!usuarioEmailExistente.isPresent()) {
                            this.autoCadastroService.cadastrarBrasilCidadao(usuarioretorno);
                        }
                        this.autoCadastroService.enviarConsiliacaoUsuario((UsuarioBrasilCidadao)usuarioBrasilCidadao.get(), usuarioretorno.getEmail(), baseUrl);
                        mv.addObject("modalConfirmacaoBrasilCidadao", (Object)true);
                        mv.addObject("email", (Object)usuarioretorno.getEmail());
                    } else if (!usuarioBrasilCidadao.isPresent()) {
                        if (!usuarioEmailExistente.isPresent()) {
                            this.autoCadastroService.cadastrarBrasilCidadao(usuarioretorno);
                        }
                        this.autoCadastroService.migrarBrasilCidadao(usuarioretorno);
                        this.autoCadastroService.enviarConsiliacaoUsuario((UsuarioBrasilCidadao)usuarioBrasilCidadao.get(), usuarioretorno.getEmail(), baseUrl);
                        mv.addObject("modalConfirmacaoBrasilCidadao", (Object)true);
                        mv.addObject("email", (Object)usuarioretorno.getEmail());
                    }
                }
            }
            catch (Exception e) {
                this.msgErro = e.getMessage();
            }
        }
        if (this.msgErro != null && !this.msgErro.isEmpty()) {
            mv.addObject("userBrasilCidadao", (Object)true);
            mv.addObject("msgBrasilCidadao", (Object)this.msgErro);
        }
        mv.addObject("urlLogin", (Object)this.brasilCidadaoOpenIdConnectConfig.gerarUrlAutorizar());
        return mv;
    }
}

