/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.controllers.page.PageWrapper;
import br.gov.planejamento.dipla.protocolo.controllers.sessions.ArquivosSession;
import br.gov.planejamento.dipla.protocolo.dto.ProtocoloFlagDTO;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.StatusEnum;
import br.gov.planejamento.dipla.protocolo.repositories.ProtocoloRepository;
import br.gov.planejamento.dipla.protocolo.repositories.TiposDocumentoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.repositories.filter.ProtocoloFilter;
import br.gov.planejamento.dipla.protocolo.response.Response;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import br.gov.planejamento.dipla.protocolo.services.EnviarProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.EventServerService;
import br.gov.planejamento.dipla.protocolo.services.ProtocoloFlagService;
import br.gov.planejamento.dipla.protocolo.services.SalvarProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.UnidadeService;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.hibernate.service.spi.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ProtocoloController {
    @Autowired
    private ArquivosSession arquivosSession;
    @Autowired
    private TiposDocumentoRepository tipoDocumentoRepository;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private ProtocoloRepository protocoloRepository;
    @Autowired
    private EnviarProtocoloService enviarProtocoloService;
    @Autowired
    private SalvarProtocoloService salvarProtocoloService;
    @Autowired
    private UnidadeService unidadeService;
    @Autowired
    private ProtocoloFlagService protocoloFlagService;
    @Autowired
    private EventServerService eventServerService;
    private final int DEFAULT_PAGEABLE_SIZE = 10;

    @GetMapping(value={"/"})
    public ModelAndView principal(Protocolo protocolo, @AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        List permissoes = this.usuarioRepository.permissoes(usuarioSistema.getUsuario());
        if (permissoes.contains("ROLE_CADASTRO") & usuarioSistema.getUsuario().getTemPerfilBrasilCidadao() == null) {
            ModelAndView mv = new ModelAndView("Dashboard");
            mv.addObject("usuario", (Object)usuarioSistema.getUsuario());
            mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
            mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
            mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
            mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
            mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
            mv.addObject("unidades", (Object)this.unidadeService.obterUnidades());
            return mv;
        }
        return this.enviar(protocolo, usuarioSistema);
    }

    @GetMapping(value={"/pendentes"})
    public ModelAndView pesquisaProtocolosPendentes(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("protocolo/PesquisaProtocolosPendentes");
        filter.setStatus(StatusEnum.PENDENTE);
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
        mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
        mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
        mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
        mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/aprovados"})
    public ModelAndView pesquisaProtocolosAprovados(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("protocolo/PesquisaProtocolosAprovados");
        filter.setStatus(StatusEnum.APROVADO);
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
        mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
        mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
        mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
        mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/aprovadosManualmente"})
    public ModelAndView pesquisaProtocolosAprovadosManualmente(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("protocolo/PesquisaProtocolosAprovadosManualmente");
        filter.setStatus(StatusEnum.APROVADO_MANUALMENTE);
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
        mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
        mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
        mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
        mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/reprovados"})
    public ModelAndView pesquisaProtocolosReprovados(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("protocolo/PesquisaProtocolosReprovados");
        filter.setStatus(StatusEnum.REPROVADO);
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
        mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
        mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
        mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
        mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/analisando"})
    public ModelAndView pesquisaProtocolosAnalisando(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("protocolo/PesquisaProtocolosAnalisando");
        filter.setStatus(StatusEnum.ANALISANDO);
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrar(filter, pageable), httpServletRequest);
        mv.addObject("protocolosAprovados", (Object)this.protocoloRepository.protocolosAprovados());
        mv.addObject("protocolosAprovadosManualmente", (Object)this.protocoloRepository.protocolosAprovadosManualmente());
        mv.addObject("protocolosReprovados", (Object)this.protocoloRepository.protocolosReprovados());
        mv.addObject("protocolosPendentes", (Object)this.protocoloRepository.protocolosPendentes());
        mv.addObject("protocolosAnalise", (Object)this.protocoloRepository.protocolosAnalisando());
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/opcoes"})
    public ModelAndView opcoes() {
        return new ModelAndView("/protocolo/OpcoesProtocolo");
    }

    @GetMapping(value={"/enviar"})
    public ModelAndView enviar(Protocolo protocolo, @AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        if (StringUtils.isEmpty((Object)protocolo.getUuid())) {
            protocolo.setUuid(UUID.randomUUID().toString());
            protocolo.setPossuiProtocoloAnterior("N");
        }
        ModelAndView mv = new ModelAndView("/protocolo/CadastroProtocolo");
        mv.addObject("usuario", (Object)usuarioSistema.getUsuario());
        mv.addObject("tiposDocumento", (Object)this.tipoDocumentoRepository.findByAtivo(Boolean.valueOf(true)));
        mv.addObject("unidades", (Object)this.unidadeService.obterUnidades());
        return mv;
    }

    @PostMapping(value={"/enviar"})
    public ModelAndView enviar(@Valid Protocolo protocolo, BindingResult result, RedirectAttributes attributes, @AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        if ("S".equals(protocolo.getPossuiProtocoloAnterior()) && StringUtils.isEmpty((Object)protocolo.getNumeroProtocoloAnterior())) {
            result.rejectValue("numeroProtocoloAnterior", "N\u00famero do protocolo Anterior \u00e9 obrigat\u00f3rio.", "N\u00famero do protocolo Anterior \u00e9 obrigat\u00f3rio.");
            return this.enviar(protocolo, usuarioSistema);
        }
        if (result.hasErrors()) {
            return this.enviar(protocolo, usuarioSistema);
        }
        List arquivoDTOList = this.arquivosSession.obterArquivos(protocolo.getUuid());
        if (CollectionUtils.isEmpty((Collection)arquivoDTOList)) {
            String msg = "Nenhum arquivo anexado, favor incluir algum arquivo antes de efetuar a protocoliza\u00e7\u00e3o.";
            result.rejectValue("arquivo", msg, msg);
            return this.enviar(protocolo, usuarioSistema);
        }
        protocolo.setUsuario(usuarioSistema.getUsuario());
        this.enviarProtocoloService.enviar(protocolo, arquivoDTOList);
        attributes.addFlashAttribute("mensagem", (Object)String.format("Protocolo N\u00ba %s salvo com sucesso.", protocolo.getNumero()));
        return new ModelAndView("redirect:/enviar");
    }

    @GetMapping(value={"/meus-protocolos"})
    public ModelAndView meusProtocolos(ProtocoloFilter filter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest, @AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        ModelAndView mv = new ModelAndView("protocolo/MeusProtocolos");
        PageWrapper paginaWrapper = new PageWrapper(this.protocoloRepository.filtrarMeusProtocolos(usuarioSistema.getUsuario(), filter, pageable), httpServletRequest);
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @GetMapping(value={"/reenvioRecibo/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> reenviarRecibo(@PathVariable(value="codigo") Protocolo protocolo, @RequestParam(value="email", required=false) String email) {
        this.enviarProtocoloService.reenviarRecibo(protocolo, email);
        Response response = new Response();
        String resposta = null;
        if (!email.isEmpty() || email != null) {
            resposta = email;
        }
        if (!protocolo.getEmail1().isEmpty() && protocolo.getEmail1() != null && protocolo.getEmail1() != "") {
            resposta = resposta + " " + protocolo.getEmail1();
        }
        if (!protocolo.getEmail2().isEmpty() && protocolo.getEmail2() != null && protocolo.getEmail2() != "") {
            resposta = resposta + " " + protocolo.getEmail2();
        }
        if (!protocolo.getUsuario().getEmail().isEmpty() && protocolo.getUsuario().getEmail() != null && protocolo.getUsuario().getEmail() != "") {
            resposta = resposta + " " + protocolo.getUsuario().getEmail();
        }
        response.setData((Object)resposta);
        return ResponseEntity.ok((Object)response);
    }

    @RequestMapping(value={"/stream"})
    public SseEmitter enableNotifier() {
        return this.eventServerService;
    }

    @PutMapping(value={"/aprovar/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> aprovar(@PathVariable(value="codigo") Protocolo protocolo, @RequestParam(value="sei", required=false) String sei, @RequestParam(value="tipo", required=false) String tipo) {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                this.enviarProtocoloService.enviarSEI(protocolo, sei, tipo);
                return "Sincronizado com Sucesso !";
            }
            catch (ServiceException e) {
                return e.getMessage();
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }).whenCompleteAsync((result, throwable) -> {
            try {
                this.eventServerService.send(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        })).exceptionally(ex -> {
            try {
                this.eventServerService.send((Object)ex.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return "erro";
        });
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/aprovarManualmente/{sei}/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> aprovarManualmente(@PathVariable(value="sei") String sei, @PathVariable(value="codigo") Protocolo protocolo) {
        protocolo.setNupe(sei);
        this.salvarProtocoloService.aprovarManualmente(protocolo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/aprovarManualmente/{sei}"})
    public ResponseEntity<Response<String>> consultarSei(@PathVariable(value="sei") String sei) {
        Optional linkSei = this.enviarProtocoloService.consultarSei(sei);
        Response response = new Response();
        if (!linkSei.isPresent()) {
            response.getErrors().add("N\u00ba SEI n\u00e3o encontrado: " + sei);
            return ResponseEntity.badRequest().body((Object)response);
        }
        response.setData(linkSei.get());
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/reprovar/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> reprovar(@PathVariable(value="codigo") Protocolo protocolo, @RequestBody String observacao) {
        protocolo.setObservacao(observacao);
        this.enviarProtocoloService.recusar(protocolo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/atualizarFlag/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> atualizarflag(@PathVariable(value="codigo") Protocolo protocolo) {
        this.salvarProtocoloService.analisando(protocolo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/atuzalizarFlagPendente/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> atuzalizarFlagPendente(@PathVariable(value="codigo") Protocolo protocolo) {
        this.salvarProtocoloService.pendente(protocolo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/atuzalizarFlagReprovado/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> atuzalizarFlagReprovado(@PathVariable(value="codigo") Protocolo protocolo) {
        this.salvarProtocoloService.reprovar(protocolo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/retirarAnalise"})
    @ResponseBody
    public ResponseEntity<?> retirarAnalise(@RequestParam(value="codigo") Protocolo protocolo) {
        this.salvarProtocoloService.pendente(protocolo);
        return ResponseEntity.ok().build();
    }

    @PutMapping(value={"/retirarAnaliseReprovado"})
    @ResponseBody
    public ResponseEntity<?> retirarAnaliseReprovado(@RequestParam(value="codigo") Protocolo protocolo) {
        this.salvarProtocoloService.reprovar(protocolo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/buscarFlag/{codigo}"})
    public ResponseEntity<Response<ProtocoloFlagDTO>> buscarStatusPorCodigp(@PathVariable(value="codigo") Long codigo) {
        Response response = new Response();
        Optional protocolo = this.protocoloFlagService.buscarStatusPorCodigo(codigo);
        if (!protocolo.isPresent()) {
            response.getErrors().add("Status n\u00e3o encontrado para o c\u00f3digo: " + codigo);
            return ResponseEntity.badRequest().body((Object)response);
        }
        response.setData((Object)this.converterProtocoloFlagDto((Protocolo)protocolo.get()));
        return ResponseEntity.ok((Object)response);
    }

    private ProtocoloFlagDTO converterProtocoloFlagDto(Protocolo protocolo) {
        ProtocoloFlagDTO protocoloFlagDTO = new ProtocoloFlagDTO();
        protocoloFlagDTO.setStatus(protocolo.getStatus().toString());
        protocolo.getObservacaoOpt().ifPresent(observacao -> protocoloFlagDTO.setObservacao(Optional.of(observacao.toString())));
        return protocoloFlagDTO;
    }
}

