/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.controllers.page.PageWrapper;
import br.gov.planejamento.dipla.protocolo.entities.TiposDocumento;
import br.gov.planejamento.dipla.protocolo.repositories.TiposDocumentoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.filter.TiposDocumentoFilter;
import br.gov.planejamento.dipla.protocolo.services.TiposDocumentoService;
import br.gov.planejamento.dipla.protocolo.services.exeptions.TipoDocumentoJaCadastradoException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/tipos-documento"})
public class TiposDocumentoController {
    @Autowired
    private TiposDocumentoRepository tiposDocumentoRepository;
    @Autowired
    private TiposDocumentoService tiposDocumentoService;

    @GetMapping(value={"/novo"})
    public ModelAndView novo(TiposDocumento tiposDocumento) {
        ModelAndView mv = new ModelAndView("tipos_documento/CadastroTiposDocumento");
        return mv;
    }

    @PostMapping(value={"/novo", "{\\d+}"})
    public ModelAndView salvar(@Valid TiposDocumento tiposDocumento, BindingResult result, RedirectAttributes attributes) {
        if (result.hasFieldErrors()) {
            return this.novo(tiposDocumento);
        }
        try {
            this.tiposDocumentoService.salvar(tiposDocumento);
        }
        catch (TipoDocumentoJaCadastradoException e) {
            result.rejectValue("descricao", null, e.getMessage());
            return this.novo(tiposDocumento);
        }
        catch (DataIntegrityViolationException e) {
            result.rejectValue("codigo", null, "N\u00e3o \u00e9 poss\u00edvel alterar o c\u00f3digo pois este Tipo de Documento j\u00e1  est\u00e1 sendo usando.");
            return this.novo(tiposDocumento);
        }
        attributes.addFlashAttribute("mensagem", (Object)"Tipo de Documento salvo com sucesso.");
        return new ModelAndView("redirect:/tipos-documento/novo");
    }

    @GetMapping
    public ModelAndView pesquisar(TiposDocumentoFilter tiposDocumentoFilter, BindingResult result, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("tipos_documento/PesquisaTiposDocumento");
        PageWrapper paginaWrapper = new PageWrapper(this.tiposDocumentoRepository.filtrar(tiposDocumentoFilter, pageable), httpServletRequest);
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @DeleteMapping(value={"/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> excluir(@PathVariable(value="codigo") TiposDocumento tiposDocumento) {
        this.tiposDocumentoService.excluir(tiposDocumento);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{codigo}"})
    public ModelAndView editar(@PathVariable(value="codigo") TiposDocumento tiposDocumento) {
        ModelAndView mv = new ModelAndView("tipos_documento/EditarTiposDocumento");
        mv.addObject((Object)tiposDocumento);
        return mv;
    }

    @PostMapping(value={"/editarTipoDocumento/{codigo}"})
    public ModelAndView editarTipoDocumento(@Valid TiposDocumento tiposDocumento, BindingResult result, RedirectAttributes attributes) {
        if (result.hasFieldErrors()) {
            return this.novo(tiposDocumento);
        }
        this.tiposDocumentoService.editar(tiposDocumento);
        attributes.addFlashAttribute("mensagem", (Object)"Tipo de Documento editado com sucesso.");
        return new ModelAndView("redirect:/tipos-documento");
    }
}

