/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers;

import br.gov.planejamento.dipla.protocolo.config.BrasilCidadaoConfig;
import br.gov.planejamento.dipla.protocolo.controllers.page.PageWrapper;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.repositories.GrupoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.repositories.filter.UsuarioFilter;
import br.gov.planejamento.dipla.protocolo.response.Response;
import br.gov.planejamento.dipla.protocolo.security.CaptchaService;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import br.gov.planejamento.dipla.protocolo.services.AutoCadastroService;
import br.gov.planejamento.dipla.protocolo.services.CadastroUsuarioService;
import br.gov.planejamento.dipla.protocolo.services.StatusUsuario;
import br.gov.planejamento.dipla.protocolo.services.exeptions.EmailUsuarioJaCadastradoException;
import br.gov.planejamento.dipla.protocolo.services.exeptions.ReCaptchaUnavailableException;
import br.gov.planejamento.dipla.protocolo.services.exeptions.SenhaObrigatoriaUsuarioException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.websocket.server.PathParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/usuarios"})
public class UsuarioController {
    @Autowired
    private CaptchaService captchaService;
    @Autowired
    private BrasilCidadaoConfig brasilCidadaoOpenIdConnectConfig;
    @Autowired
    private CadastroUsuarioService cadastroUsuarioService;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private GrupoRepository grupoRepository;
    @Autowired
    private AutoCadastroService autoCadastroService;

    @GetMapping(value={"/auto-cadastro"})
    public ModelAndView autoCadastro(Usuario usuario) {
        ModelAndView mv = new ModelAndView("/usuario/NovoUsuario");
        return mv;
    }

    @GetMapping(value={"/novo"})
    public ModelAndView novo(Usuario usuario) {
        ModelAndView mv = new ModelAndView("/usuario/CadastroUsuario");
        List grupos = this.grupoRepository.findAll();
        if (!usuario.isNovo()) {
            List permissoes = this.usuarioRepository.permissoes(usuario);
            if (permissoes.contains("ROLE_BRASILCIDADAO")) {
                grupos.remove(this.grupoRepository.findOne((Serializable)Long.valueOf(2L)));
            } else {
                grupos.remove(this.grupoRepository.findOne((Serializable)Long.valueOf(3L)));
            }
        } else {
            grupos.remove(this.grupoRepository.findOne((Serializable)Long.valueOf(3L)));
        }
        mv.addObject("grupos", (Object)grupos);
        return mv;
    }

    @GetMapping(value={"/esqueci-senha"})
    public ModelAndView esqueciSenha(Usuario usuario) {
        ModelAndView mv = new ModelAndView("/usuario/EsqueciSenha");
        return mv;
    }

    @PostMapping(value={"/esqueci-senha"})
    public ModelAndView enviarSenhaPorEmail(Usuario usuario, BindingResult result, RedirectAttributes attributes, HttpServletRequest httpServletRequest) {
        String response = httpServletRequest.getParameter("g-recaptcha-response");
        try {
            this.captchaService.processResponse(response);
            this.cadastroUsuarioService.reiniciarSenha(usuario);
            attributes.addFlashAttribute("mensagem", (Object)("Foi enviado um email para " + usuario.getEmail() + " com a nova senha de acesso."));
            return new ModelAndView("redirect:/usuarios/esqueci-senha");
        }
        catch (ReCaptchaUnavailableException e) {
            ModelAndView mv = new ModelAndView("/usuario/EsqueciSenha");
            mv.addObject("erroCaptch", (Object)true);
            mv.addObject("erroCaptchMsg", (Object)e.getMessage());
            mv.addObject("usuario", (Object)usuario);
            return mv;
        }
        catch (Exception e) {
            result.rejectValue("email", e.getMessage(), e.getMessage());
            return this.esqueciSenha(usuario);
        }
    }

    @PostMapping(value={"/auto-cadastro"})
    public ModelAndView salvarAutoCadastro(@Valid Usuario usuario, BindingResult result, RedirectAttributes attributes, HttpServletRequest httpServletRequest) {
        if (result.hasErrors()) {
            return this.autoCadastro(usuario);
        }
        String response = httpServletRequest.getParameter("g-recaptcha-response");
        try {
            this.captchaService.processResponse(response);
            usuario.setUrlConfirmacaoCadastro(httpServletRequest.getRequestURL().toString());
            this.autoCadastroService.salvar(usuario);
            attributes.addFlashAttribute("mensagem", (Object)"Cadastro realizado com sucesso.");
        }
        catch (EmailUsuarioJaCadastradoException e) {
            result.rejectValue("email", e.getMessage(), e.getMessage());
            return this.autoCadastro(usuario);
        }
        catch (SenhaObrigatoriaUsuarioException e) {
            result.rejectValue("senha", e.getMessage(), e.getMessage());
            return this.autoCadastro(usuario);
        }
        catch (ReCaptchaUnavailableException e) {
            ModelAndView mv = new ModelAndView("/usuario/NovoUsuario");
            mv.addObject("erroCaptch", (Object)true);
            mv.addObject("erroCaptchMsg", (Object)e.getMessage());
            mv.addObject("usuario", (Object)usuario);
            return mv;
        }
        return new ModelAndView("redirect:/usuarios/auto-cadastro");
    }

    @GetMapping(value={"/auto-brasil-cidadao/{hasBrasilCidadao}/{hasEmail}"})
    public ModelAndView confirmarConsiliacaoBrasil(@PathVariable(value="hasBrasilCidadao") String hashBrasilCidadao, @PathVariable(value="hasEmail") String hashEmail) {
        this.autoCadastroService.confirmarConciliacao(hashBrasilCidadao, hashEmail);
        ModelAndView mv = new ModelAndView("/fragments/ConfirmacaoConsiliacaoUsuario");
        mv.addObject("urlLogin", (Object)this.brasilCidadaoOpenIdConnectConfig.gerarUrlAutorizar());
        return mv;
    }

    @GetMapping(value={"/auto-desbloqueio/{hashUser}"})
    public ModelAndView confirmarConsiliacaoBrasil(@PathVariable(value="hashUser") String hashUser) {
        this.autoCadastroService.confirmarDesbloqueio(hashUser);
        ModelAndView mv = new ModelAndView("/fragments/ConfirmacaoDesbloqueioUsuario");
        mv.addObject("urlLogin", (Object)this.brasilCidadaoOpenIdConnectConfig.gerarUrlAutorizar());
        return mv;
    }

    @GetMapping(value={"/auto-cadastro/{hashUsuario}"})
    public ModelAndView confirmarCadastro(@PathVariable(value="hashUsuario") String hashUsuario) {
        this.autoCadastroService.confirmarCadastro(hashUsuario);
        return new ModelAndView("/fragments/ConfirmacaoCadastroSucesso");
    }

    @PostMapping(value={"/novo", "{\\d+}"})
    public ModelAndView salvar(@Valid Usuario usuario, BindingResult result, RedirectAttributes attributes) {
        if (result.hasErrors()) {
            return this.novo(usuario);
        }
        try {
            this.cadastroUsuarioService.salvar(usuario);
        }
        catch (EmailUsuarioJaCadastradoException e) {
            result.rejectValue("email", e.getMessage(), e.getMessage());
            return this.novo(usuario);
        }
        catch (SenhaObrigatoriaUsuarioException e) {
            result.rejectValue("senha", e.getMessage(), e.getMessage());
            return this.novo(usuario);
        }
        attributes.addFlashAttribute("mensagem", (Object)"Usu\u00e1rio salvo com sucesso");
        return new ModelAndView("redirect:/usuarios/novo");
    }

    @GetMapping(value={"/{codigo}"})
    public ModelAndView editar(@PathVariable Long codigo) {
        Usuario usuario = this.usuarioRepository.buscarComGrupos(codigo);
        ModelAndView mv = this.novo(usuario);
        mv.addObject((Object)usuario);
        return mv;
    }

    @GetMapping
    public ModelAndView pesquisar(UsuarioFilter usuarioFilter, @PageableDefault(size=10) Pageable pageable, HttpServletRequest httpServletRequest) {
        ModelAndView mv = new ModelAndView("/usuario/PesquisaUsuarios");
        mv.addObject("grupos", (Object)this.grupoRepository.findAll());
        PageWrapper paginaWrapper = new PageWrapper(this.usuarioRepository.filtrar(usuarioFilter, pageable), httpServletRequest);
        mv.addObject("pagina", (Object)paginaWrapper);
        return mv;
    }

    @PutMapping(value={"/status"})
    @ResponseStatus(value=HttpStatus.OK)
    public void atualizarStatus(@RequestParam(value="codigos[]") Long[] codigos, @RequestParam(value="status") StatusUsuario statusUsuario) {
        this.cadastroUsuarioService.alterarStatus(codigos, statusUsuario);
    }

    @DeleteMapping(value={"/{codigo}"})
    @ResponseBody
    public ResponseEntity<?> excluir(@PathParam(value="codigo") Usuario usuario) {
        Response response = new Response();
        try {
            this.cadastroUsuarioService.excluir(usuario);
        }
        catch (Exception e) {
            response.getErrors().add("Erro usu\u00e1rio possui registros no banco, que impedem exclus\u00e3o do usu\u00e1rio.");
            return ResponseEntity.badRequest().body((Object)response);
        }
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/perfil"})
    public ModelAndView perfil(@AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        ModelAndView mv = new ModelAndView("/usuario/PerfilUsuario");
        mv.addObject("usuario", this.usuarioRepository.findOne((Serializable)usuarioSistema.getUsuario().getCodigo()));
        return mv;
    }

    @PostMapping(value={"/perfil"})
    public ModelAndView atualizarPerfil(@Valid Usuario usuario, BindingResult result, RedirectAttributes attributes, @AuthenticationPrincipal UsuarioSistema usuarioSistema) {
        if (result.hasErrors()) {
            return new ModelAndView("/usuario/PerfilUsuario");
        }
        try {
            Usuario usuarioGrupo = this.usuarioRepository.buscarComGrupos(usuario.getCodigo());
            usuario.setGrupos(usuarioGrupo.getGrupos());
            this.cadastroUsuarioService.salvar(usuario);
        }
        catch (EmailUsuarioJaCadastradoException e) {
            result.rejectValue("email", e.getMessage(), e.getMessage());
            return this.novo(usuario);
        }
        catch (SenhaObrigatoriaUsuarioException e) {
            result.rejectValue("senha", e.getMessage(), e.getMessage());
            return this.novo(usuario);
        }
        attributes.addFlashAttribute("mensagem", (Object)"Perfil atualizado com sucesso. Para que as modifica\u00e7\u00f5es sejam aplicadas favor logar novamente no sistema.");
        return new ModelAndView("redirect:/usuarios/perfil");
    }
}

