/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers.page;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.web.util.UriComponentsBuilder;

public class PageWrapper<T> {
    private final Page<T> page;
    private final UriComponentsBuilder uriBuilder;

    public PageWrapper(Page<T> page, HttpServletRequest httpServletRequest) {
        this.page = page;
        String httpUrl = httpServletRequest.getRequestURL().append(httpServletRequest.getQueryString() != null ? "?" + httpServletRequest.getQueryString() : "").toString().replaceAll("\\+", "%20").replaceAll("excluido", "");
        this.uriBuilder = UriComponentsBuilder.fromHttpUrl((String)httpUrl);
    }

    public List<T> getConteudo() {
        return this.page.getContent();
    }

    public String getQuantidadeParcial() {
        if (this.page.getNumber() == 0) {
            return " de 1 a " + this.page.getContent().size();
        }
        int inicial = this.page.getSize() * this.page.getNumber();
        return " de " + inicial + " a " + (inicial + this.page.getContent().size());
    }

    public Long getQuantidadeTotal() {
        return this.page.getTotalElements();
    }

    public boolean isVazia() {
        return this.page.getContent().isEmpty();
    }

    public int getAtual() {
        return this.page.getNumber();
    }

    public int getPrimeira() {
        return 0;
    }

    public int getUltimaPagina() {
        return this.page.getTotalPages() - 1;
    }

    public boolean isPrimeira() {
        return this.page.isFirst();
    }

    public boolean isUltima() {
        return this.page.isLast();
    }

    public int getTotal() {
        return this.page.getTotalPages();
    }

    public String urlParaPagina(int pagina) {
        return this.uriBuilder.replaceQueryParam("page", new Object[]{pagina}).build(true).encode().toUriString();
    }

    public String urlOrdenada(String propriedade) {
        UriComponentsBuilder uriBuilderOrder = UriComponentsBuilder.fromUriString((String)this.uriBuilder.build(true).encode().toUriString());
        String valorSort = String.format("%s,%s", propriedade, this.inverterDirecao(propriedade));
        return uriBuilderOrder.replaceQueryParam("sort", new Object[]{valorSort}).build(true).encode().toUriString();
    }

    public String inverterDirecao(String propriedade) {
        Sort.Order order;
        String direcao = "asc";
        Sort.Order order2 = order = this.page.getSort() != null ? this.page.getSort().getOrderFor(propriedade) : null;
        if (order != null) {
            direcao = Sort.Direction.ASC.equals((Object)order.getDirection()) ? "desc" : "asc";
        }
        return direcao;
    }

    public boolean descendente(String propriedade) {
        return this.inverterDirecao(propriedade).equals("asc");
    }

    public boolean ordenada(String propriedade) {
        Sort.Order order;
        Sort.Order order2 = order = this.page.getSort() != null ? this.page.getSort().getOrderFor(propriedade) : null;
        if (order == null) {
            return false;
        }
        return this.page.getSort().getOrderFor(propriedade) != null;
    }

    public boolean exibirBotaoAtual(int pagina) {
        if (this.getAtual() == pagina) {
            return true;
        }
        if (pagina >= this.getAtual() && pagina <= this.getAtual() + 2) {
            return true;
        }
        return pagina <= this.getAtual() && pagina >= this.getAtual() - 2;
    }
}

