/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.controllers.sessions;

import br.gov.planejamento.dipla.protocolo.dto.ArquivoDTO;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.annotation.SessionScope;

@SessionScope
@Component
public class ArquivosSession {
    private final double TAMANHO_PERMITIDO_KB = 100000.0;
    @Autowired
    private ArquivoStorage arquivoStorage;
    private final Map<String, List<ArquivoDTO>> arquivosMap = new HashMap();

    public void adicionarArquivo(String uuid, ArquivoDTO arquivoDTO) {
        ArrayList<ArquivoDTO> arquivosDTOList = (ArrayList<ArquivoDTO>)this.arquivosMap.get(uuid);
        if (CollectionUtils.isEmpty((Collection)arquivosDTOList)) {
            arquivosDTOList = new ArrayList<ArquivoDTO>();
        }
        if (this.isArquivoAdicionado(arquivoDTO.getNome(), arquivosDTOList)) {
            throw new RuntimeException("Arquivo j\u00e1 adicionado");
        }
        this.verificaTamanhoPermitido(arquivoDTO, arquivosDTOList);
        arquivosDTOList.add(arquivoDTO);
        this.arquivosMap.put(uuid, arquivosDTOList);
    }

    public void excluirArquivos(String uuid, ArquivoDTO arquivoDTO) {
        this.arquivosMap.remove(uuid);
    }

    public void excluirArquivo(String uuid, String nome) {
        List arquivos = (List)this.arquivosMap.get(uuid);
        ArquivoDTO arquivoDTOExclusao = arquivos.stream().filter(arquivoDTO -> arquivoDTO.getNome().equals(nome)).findAny().get();
        arquivos.remove(arquivoDTOExclusao);
        this.arquivoStorage.excluirTemporario(nome);
    }

    public List<ArquivoDTO> obterArquivos(String uuid) {
        return (List)this.arquivosMap.get(uuid);
    }

    private boolean isArquivoAdicionado(String nome, List<ArquivoDTO> arquivos) {
        return arquivos.stream().anyMatch(arquivo -> arquivo.getNome().equals(nome));
    }

    private void verificaTamanhoPermitido(ArquivoDTO arquivoDTO, List<ArquivoDTO> arquivos) {
        try {
            double size = this.parseDouble(arquivoDTO.getTamanho());
            for (ArquivoDTO arquivo : arquivos) {
                size += this.parseDouble(arquivo.getTamanho()).doubleValue();
            }
            if (size > 100000.0) {
                throw new RuntimeException("O limite de arquivos foi excedido e dever\u00e1 ser feita uma nova solicita\u00e7\u00e3o fazendo refer\u00eancia ao n\u00famero de protocolo que deseja complementar.");
            }
        }
        catch (ParseException pe) {
            throw new RuntimeException("Erro no c\u00e1lculo das quantidades de arquivos.");
        }
    }

    private Double parseDouble(String valor) throws ParseException {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale("pt", "BR"));
        try {
            return (Double)df.parse(valor);
        }
        catch (Exception e) {
            return new Double(((Long)df.parse(valor)).longValue());
        }
    }
}

