/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.entities;

import br.gov.planejamento.dipla.protocolo.entities.Arquivos;
import br.gov.planejamento.dipla.protocolo.entities.StatusEnum;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@DynamicUpdate
@Table(name="protocolo", schema="protocolo")
public class Protocolo
implements Serializable {
    @Transient
    private static final String padraoURL = "https://protocolointegrado.gov.br/protocolo/documento/detalhes_documento.jsf?protocolo=";
    private String observacao;
    private String erroWs;
    @Transient
    private String linkNup;
    @Transient
    private static final String urlNup = "";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long codigo;
    private String numero;
    @Column(name="data_hora")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHora;
    @ManyToOne
    @JoinColumn(name="codigo_usuario")
    private Usuario usuario;
    @Enumerated(value=EnumType.STRING)
    private StatusEnum status = StatusEnum.PENDENTE;
    @Email(message="Formato do e-mail 1 est\u00e1 inv\u00e1lido.")
    @SafeHtml(whitelistType=SafeHtml.WhiteListType.NONE)
    private String email1;
    @Email(message="Formato do e-mail 2 est\u00e1 inv\u00e1lido.")
    @SafeHtml(whitelistType=SafeHtml.WhiteListType.NONE)
    private String email2;
    @Column(name="data_envio")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataEnvio;
    private String nupe;
    @OneToMany(mappedBy="protocolo", cascade={CascadeType.ALL})
    private List<Arquivos> arquivosList = new ArrayList();
    @Column(name="nr_protocolo_anterior")
    private String numeroProtocoloAnterior;
    private Long idUnidade;
    @Transient
    private String uuid;
    @Transient
    private String interessado;
    @Transient
    private Arquivos arquivo = new Arquivos();
    @Column(name="linksei", nullable=true)
    private String linkSEI;
    @Transient
    private String possuiProtocoloAnterior;

    @Column(name="observacao", nullable=true)
    public String getObservacao() {
        return this.observacao;
    }

    @Column(name="erro_ws", nullable=true)
    public String erroWs() {
        return this.erroWs;
    }

    @Transient
    public Optional<String> getObservacaoOpt() {
        return Optional.ofNullable(this.observacao);
    }

    public void setObservaco(String observacao) {
        this.observacao = observacao;
    }

    @PrePersist
    private void prePersist() {
        this.status = StatusEnum.PENDENTE;
    }

    public String getDataHoraFormatada() {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(this.dataHora);
    }

    public String getDataFormatada() {
        return new SimpleDateFormat("dd/MM/yyyy").format(this.dataHora);
    }

    public String getDataEnvioFormatada() {
        if (this.dataEnvio != null) {
            return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(this.dataEnvio);
        }
        return urlNup;
    }

    public boolean isAprovado() {
        return StatusEnum.APROVADO.equals((Object)this.status) || StatusEnum.APROVADO_MANUALMENTE.equals((Object)this.status);
    }

    public String toString() {
        StringBuilder retorno = new StringBuilder();
        retorno.append("N\u00ba Protocolo Provis\u00f3rio: " + this.numero + "\n");
        retorno.append("Data e Hora: " + this.getDataHoraFormatada() + "\n");
        retorno.append("Nome: " + this.usuario.getNome() + "\n");
        retorno.append("Telefone: " + this.usuario.getTelefone() + "\n");
        retorno.append("E-mail: " + this.usuario.getEmail() + "\n");
        return retorno.toString();
    }

    public String getLinkNup() {
        if (this.nupe != null && !this.nupe.isEmpty() && this.linkNup == null) {
            this.linkNup = padraoURL + this.nupe.replace("-", urlNup).replace(".", urlNup).replace("/", urlNup);
        }
        return this.linkNup;
    }

    public boolean isExibirLinkNup() {
        return !"Processando...".equals(this.nupe);
    }

    public String toLog() {
        return "Protocolo [observacao=" + this.observacao + ", erroWs=" + this.erroWs + ", linkNup=" + this.linkNup + ", codigo=" + this.codigo + ", numero=" + this.numero + ", dataHora=" + this.dataHora + ", usuario=" + this.usuario + ", status=" + this.status + ", email1=" + this.email1 + ", email2=" + this.email2 + ", dataEnvio=" + this.dataEnvio + ", nupe=" + this.nupe + ", arquivosList=" + this.arquivosList + ", numeroProtocoloAnterior=" + this.numeroProtocoloAnterior + ", idUnidade=" + this.idUnidade + ", uuid=" + this.uuid + ", interessado=" + this.interessado + ", arquivo=" + this.arquivo + ", linkSEI=" + this.linkSEI + ", possuiProtocoloAnterior=" + this.possuiProtocoloAnterior + "]";
    }

    public String getErroWs() {
        return this.erroWs;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public String getNumero() {
        return this.numero;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public Usuario getUsuario() {
        return this.usuario;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public String getEmail1() {
        return this.email1;
    }

    public String getEmail2() {
        return this.email2;
    }

    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public String getNupe() {
        return this.nupe;
    }

    public List<Arquivos> getArquivosList() {
        return this.arquivosList;
    }

    public String getNumeroProtocoloAnterior() {
        return this.numeroProtocoloAnterior;
    }

    public Long getIdUnidade() {
        return this.idUnidade;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getInteressado() {
        return this.interessado;
    }

    public Arquivos getArquivo() {
        return this.arquivo;
    }

    public String getLinkSEI() {
        return this.linkSEI;
    }

    public String getPossuiProtocoloAnterior() {
        return this.possuiProtocoloAnterior;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setErroWs(String erroWs) {
        this.erroWs = erroWs;
    }

    public void setLinkNup(String linkNup) {
        this.linkNup = linkNup;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public void setNumero(String numero) {
        this.numero = numero;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public void setEmail1(String email1) {
        this.email1 = email1;
    }

    public void setEmail2(String email2) {
        this.email2 = email2;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    public void setNupe(String nupe) {
        this.nupe = nupe;
    }

    public void setArquivosList(List<Arquivos> arquivosList) {
        this.arquivosList = arquivosList;
    }

    public void setNumeroProtocoloAnterior(String numeroProtocoloAnterior) {
        this.numeroProtocoloAnterior = numeroProtocoloAnterior;
    }

    public void setIdUnidade(Long idUnidade) {
        this.idUnidade = idUnidade;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setInteressado(String interessado) {
        this.interessado = interessado;
    }

    public void setArquivo(Arquivos arquivo) {
        this.arquivo = arquivo;
    }

    public void setLinkSEI(String linkSEI) {
        this.linkSEI = linkSEI;
    }

    public void setPossuiProtocoloAnterior(String possuiProtocoloAnterior) {
        this.possuiProtocoloAnterior = possuiProtocoloAnterior;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Protocolo)) {
            return false;
        }
        Protocolo other = (Protocolo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Protocolo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

