/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.entities;

import br.gov.planejamento.dipla.protocolo.entities.Grupo;
import br.gov.planejamento.dipla.protocolo.validation.AtributoConfirmacao;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="usuario", schema="protocolo")
@AtributoConfirmacao(atributo="senha", atributoConfirmacao="confirmacaoSenha", message="Confirma\u00e7\u00e3o da senha n\u00e3o confere")
public class Usuario
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long codigo;
    @Size(max=50, message="O nome s\u00f3 pode conter at\u00e9 50 caracteres.")
    @NotBlank(message="Nome \u00e9 obrigat\u00f3rio.")
    @Column(name="nome")
    @SafeHtml(whitelistType=SafeHtml.WhiteListType.NONE)
    private String nome;
    @Size(max=50, message="O nome social s\u00f3 pode conter at\u00e9 50 caracteres.")
    @Column(name="nome_social", nullable=true)
    @SafeHtml(whitelistType=SafeHtml.WhiteListType.NONE)
    private String nome_social;
    @NotBlank(message="E-mail \u00e9 obrigat\u00f3rio.")
    @Email(message="E-mail inv\u00e1lido")
    @SafeHtml(whitelistType=SafeHtml.WhiteListType.NONE)
    private String email;
    private String senha;
    @NotBlank(message="O telefone \u00e9 de preenchimento obrigat\u00f3rio.")
    @Length(min=14, message="Formato de telefone inv\u00e1lido. Formato esperado (99) 9999-9999 ou (99) 99999-9999 ")
    private String telefone;
    private Boolean ativo;
    @NotNull(message="Grupo \u00e9 obrigat\u00f3rio")
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="usuario_grupo", joinColumns={@JoinColumn(name="codigo_usuario")}, inverseJoinColumns={@JoinColumn(name="codigo_grupo")})
    private List<Grupo> grupos;
    @Transient
    private String confirmacaoSenha;
    @Transient
    private String nomeOriginal;
    @Transient
    private Boolean temPerfilAdministrador;
    @Transient
    private Boolean temPerfilBrasilCidadao;
    @Transient
    private String urlConfirmacaoCadastro;
    @Transient
    private String urlDesbloqueio;

    public boolean isNovo() {
        return this.codigo == null;
    }

    public String getNome() {
        if (this.isUsaNomeSocial()) {
            return this.nome_social;
        }
        return this.nome;
    }

    public String getNomeReal() {
        return this.nome;
    }

    public String getNomeOriginal() {
        return this.nome;
    }

    public void setNomeOriginal(String nomeOriginal) {
        this.nome = nomeOriginal;
    }

    public boolean isUsaNomeSocial() {
        return this.nome_social != null && !this.nome_social.trim().isEmpty();
    }

    @PreUpdate
    private void preUpdate() {
        this.confirmacaoSenha = this.senha;
    }

    public Long getCodigo() {
        return this.codigo;
    }

    public String getNome_social() {
        return this.nome_social;
    }

    public String getEmail() {
        return this.email;
    }

    public String getSenha() {
        return this.senha;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public List<Grupo> getGrupos() {
        return this.grupos;
    }

    public String getConfirmacaoSenha() {
        return this.confirmacaoSenha;
    }

    public Boolean getTemPerfilAdministrador() {
        return this.temPerfilAdministrador;
    }

    public Boolean getTemPerfilBrasilCidadao() {
        return this.temPerfilBrasilCidadao;
    }

    public String getUrlConfirmacaoCadastro() {
        return this.urlConfirmacaoCadastro;
    }

    public String getUrlDesbloqueio() {
        return this.urlDesbloqueio;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setNome_social(String nome_social) {
        this.nome_social = nome_social;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public void setGrupos(List<Grupo> grupos) {
        this.grupos = grupos;
    }

    public void setConfirmacaoSenha(String confirmacaoSenha) {
        this.confirmacaoSenha = confirmacaoSenha;
    }

    public void setTemPerfilAdministrador(Boolean temPerfilAdministrador) {
        this.temPerfilAdministrador = temPerfilAdministrador;
    }

    public void setTemPerfilBrasilCidadao(Boolean temPerfilBrasilCidadao) {
        this.temPerfilBrasilCidadao = temPerfilBrasilCidadao;
    }

    public void setUrlConfirmacaoCadastro(String urlConfirmacaoCadastro) {
        this.urlConfirmacaoCadastro = urlConfirmacaoCadastro;
    }

    public void setUrlDesbloqueio(String urlDesbloqueio) {
        this.urlDesbloqueio = urlDesbloqueio;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Usuario)) {
            return false;
        }
        Usuario other = (Usuario)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        return !(this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Usuario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        return result;
    }
}

