/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.exceptionhandler;

import br.gov.planejamento.dipla.protocolo.exceptionhandler.ProtocoloExceptionHandler;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MultipartException;

@ControllerAdvice
public class ProtocoloExceptionHandler {
    NumberFormat numberFormatter = new DecimalFormat("#0");

    @ExceptionHandler(value={MultipartException.class})
    public ResponseEntity<Erro> handleSizeLimitExceededException(MultipartException e) {
        String message = "Invalid form data";
        if (e.getCause() instanceof IllegalStateException && e.getRootCause() instanceof FileUploadBase.SizeException) {
            FileUploadBase.SizeException sizeException = (FileUploadBase.SizeException)e.getRootCause();
            if (sizeException instanceof FileUploadBase.FileSizeLimitExceededException) {
                FileUploadBase.FileSizeLimitExceededException cause = (FileUploadBase.FileSizeLimitExceededException)sizeException;
                message = "O arquivo deve ser menor que: " + this.numberFormatter.format((double)cause.getPermittedSize() / Math.pow(2.0, 20.0)) + "MB";
            } else if (sizeException instanceof FileUploadBase.SizeLimitExceededException) {
                FileUploadBase.SizeLimitExceededException cause = (FileUploadBase.SizeLimitExceededException)sizeException;
                message = "O arquivo deve ser menor que: " + this.numberFormatter.format((double)cause.getPermittedSize() / Math.pow(2.0, 20.0)) + "MB";
            }
        }
        return new ResponseEntity((Object)new Erro(message), HttpStatus.BAD_REQUEST);
    }
}

