/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.mail;

import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEmail;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.EmailEnum;
import br.gov.planejamento.dipla.protocolo.entities.Metadado;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoEmailRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.MetadadoRepository;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.dialect.SpringStandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;

@Component
public class Mailer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mailer.class);
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private TemplateEngine thymeleaf;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private ConfiguracaoEmailRepository configuracaoEmailRepository;
    @Autowired
    private MetadadoRepository metadadoRepository;

    @Async
    public void enviarConfirmacao(Protocolo protocolo) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("protocolo", (Object)protocolo);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_PROTOCOLO));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(protocolo.getUsuario().getEmail());
            if (!StringUtils.isEmpty((Object)protocolo.getEmail1())) {
                helper.addCc(protocolo.getEmail1());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getEmail2())) {
                helper.addCc(protocolo.getEmail2());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getInteressado())) {
                helper.addCc(protocolo.getInteressado());
            }
            helper.setSubject(String.format("Protocolo de Entrega de Documentos N\u00ba Provis\u00f3rio: %s", protocolo.getNumero()));
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarAceite(Protocolo protocolo) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("protocolo", (Object)protocolo);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_RECEBIMENTO_SEI));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(protocolo.getUsuario().getEmail());
            if (!StringUtils.isEmpty((Object)protocolo.getEmail1())) {
                helper.addCc(protocolo.getEmail1());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getEmail2())) {
                helper.addCc(protocolo.getEmail2());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getInteressado())) {
                helper.addCc(protocolo.getInteressado());
            }
            helper.setSubject(String.format("Protocolo de Recebimento de Documentos NUP: %s", protocolo.getNupe()));
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarRecusa(Protocolo protocolo) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("protocolo", (Object)protocolo);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_NEGADO));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(protocolo.getUsuario().getEmail());
            if (!StringUtils.isEmpty((Object)protocolo.getEmail1())) {
                helper.addCc(protocolo.getEmail1());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getEmail2())) {
                helper.addCc(protocolo.getEmail2());
            }
            if (!StringUtils.isEmpty((Object)protocolo.getInteressado())) {
                helper.addCc(protocolo.getInteressado());
            }
            helper.setSubject(String.format("Informa\u00e7\u00f5es sobre o N\u00famero do Protocolo Provis\u00f3rio %s", protocolo.getNumero()));
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarNovaSenha(Usuario usuario) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("usuario", (Object)usuario);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_ESQUECI_SENHA));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(usuario.getEmail());
            helper.setSubject("Solicita\u00e7\u00e3o de Nova Senha");
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarConfirmacaoCadastro(Usuario usuario) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("usuario", (Object)usuario);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_CADASTRO));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(usuario.getEmail());
            helper.setSubject("Confirma\u00e7\u00e3o de cadastro no sistema de protocolo");
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarConsiliacaoUsuario(Usuario usuario, String emailEnvio) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("usuario", (Object)usuario);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_CONSOLIDACAO));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(emailEnvio);
            helper.setSubject("Confirma\u00e7\u00e3o de cadastro no sistema de protocolo");
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarDesbloqueio(Usuario usuario, String emailEnvio) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("usuario", (Object)usuario);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_DESBLOQUEIO));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(emailEnvio);
            helper.setSubject("Confirma\u00e7\u00e3o de cadastro no sistema de protocolo");
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    @Async
    public void enviarEmailErroEnvioSEI(Protocolo protocolo, String msgErro) {
        Context context = new Context(new Locale("pt", "BR"));
        context.setVariable("protocolo", (Object)protocolo);
        context.setVariable("msgErro", (Object)msgErro);
        try {
            String email = this.processarTemplate(context, this.montarEmail(EmailEnum.EMAIL_CONTEUDO_ERRO_SEI));
            MimeMessage mimeMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
            helper.setFrom(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.MAIL_FROM));
            helper.setTo(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.EMAIL_RESPONSAVEL));
            helper.setSubject("Erro no envio do protocolo " + protocolo.getNumero() + " para o SEI");
            helper.setText(email, true);
            helper.addInline("logo", (Resource)new ClassPathResource("static/images/brasao-brasil.png"));
            this.mailSender.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOGGER.error("Erro enviando e-mail", (Throwable)e);
        }
    }

    private String recuperarMetadados(String texto, List<Metadado> listMetadado) {
        if (texto != null) {
            Context context = new Context(new Locale("pt", "BR"));
            for (Metadado metadado : listMetadado) {
                texto = texto.replace("{$" + metadado.getNome() + "}", metadado.getValor());
            }
        }
        return texto;
    }

    private String montarEmail(EmailEnum emailEnum) {
        String email = "<!DOCTYPE html>\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:th=\"http://www.thymeleaf.org\" >\n    <head>\n        <meta charset=\"UTF-8\" />\n    </head>\n<body style=\"font-family: Arial; font-size: 14px;\">";
        Optional cabecalho = this.configuracaoEmailRepository.findByNome(EmailEnum.EMAIL_CABECALHO.name());
        Optional conteudo = this.configuracaoEmailRepository.findByNome(emailEnum.name());
        Optional rodape = this.configuracaoEmailRepository.findByNome(EmailEnum.EMAIL_RODAPE.name());
        email = email.concat(this.recuperarMetadados(((ConfiguracaoEmail)cabecalho.get()).getValor(), this.metadadoRepository.findByEmail((ConfiguracaoEmail)cabecalho.get())));
        email = email.concat(this.recuperarMetadados(((ConfiguracaoEmail)conteudo.get()).getValor(), this.metadadoRepository.findByEmail((ConfiguracaoEmail)conteudo.get())));
        email = email.concat(this.recuperarMetadados(((ConfiguracaoEmail)rodape.get()).getValor(), this.metadadoRepository.findByEmail((ConfiguracaoEmail)rodape.get())));
        email = email.concat("</body>\n</html>");
        return email;
    }

    private String processarTemplate(Context context, String email) {
        StringTemplateResolver templateResolver = new StringTemplateResolver();
        templateResolver.setTemplateMode(TemplateMode.HTML);
        SpringStandardDialect dialect = new SpringStandardDialect();
        dialect.setEnableSpringELCompiler(true);
        SpringTemplateEngine engine = new SpringTemplateEngine();
        engine.setDialect((IDialect)dialect);
        engine.setEnableSpringELCompiler(true);
        engine.setTemplateResolver((ITemplateResolver)templateResolver);
        String emailProcessado = engine.process(email, (IContext)context);
        return emailProcessado;
    }
}

