/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories;

import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.repositories.helper.protocolo.ProtocoloRepositoryQueries;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface ProtocoloRepository
extends JpaRepository<Protocolo, Long>,
ProtocoloRepositoryQueries {
    @Query(value="select count(status) from Protocolo where status = 'APROVADO' or status = 'PROCESSANDO'")
    public BigDecimal protocolosAprovados();

    @Query(value="select count(status) from Protocolo where status = 'APROVADO_MANUALMENTE'")
    public BigDecimal protocolosAprovadosManualmente();

    @Query(value="select count(status) from Protocolo where status = 'REPROVADO'")
    public BigDecimal protocolosReprovados();

    @Query(value="select count(status) from Protocolo where status = 'PENDENTE'")
    public BigDecimal protocolosPendentes();

    @Query(value="select count(status) from Protocolo where status = 'ANALISANDO'")
    public BigDecimal protocolosAnalisando();

    @Transactional(readOnly=true)
    public Protocolo findByCodigo(Long var1);

    public List<Protocolo> findByUsuario(Usuario var1);
}

