/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories.helper.configuracao;

import br.gov.planejamento.dipla.protocolo.entities.Configuracao;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.repositories.filter.ConfiguracaoFilter;
import br.gov.planejamento.dipla.protocolo.repositories.helper.configuracao.ConfiguracaoRepositoryQueries;
import br.gov.planejamento.dipla.protocolo.repositories.paginacao.PaginacaoUtil;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ConfiguracaoRepositoryImpl
implements ConfiguracaoRepositoryQueries {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private PaginacaoUtil paginacaoUtil;

    public String recuperarValor(ConfiguracaoEnum nome) {
        Optional valor = this.manager.createQuery("select distinct c.valor from Configuracao c where c.nome= :nome", String.class).setParameter("nome", (Object)nome.name()).getResultList().stream().findFirst();
        return (String)valor.get();
    }

    public Page<Configuracao> filtrar(ConfiguracaoFilter configuracaoFilter, Pageable pageable) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Configuracao.class);
        this.paginacaoUtil.preparaPaginacao(criteria, pageable);
        this.adicionarFiltro(configuracaoFilter, criteria);
        return new PageImpl(criteria.list(), pageable, this.total(configuracaoFilter).longValue());
    }

    public Optional<Configuracao> findByNome(String nome) {
        Optional<Configuracao> valor = this.manager.createQuery("from Configuracao c where c.nome= :nome", Configuracao.class).setParameter("nome", (Object)nome).getResultList().stream().findFirst();
        return valor;
    }

    private void adicionarFiltro(ConfiguracaoFilter filtro, Criteria criteria) {
        if (filtro != null) {
            if (filtro.getPesquisa() != null) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)"nome", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"descricao", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"valor", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE)}));
            }
            if (filtro.getClassificacao() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"classificacao", (Object)filtro.getClassificacao()));
            }
        }
    }

    private Long total(ConfiguracaoFilter configuracaoFilter) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Configuracao.class);
        this.adicionarFiltro(configuracaoFilter, criteria);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }
}

