/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories.helper.protocolo;

import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.StatusEnum;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.repositories.filter.ProtocoloFilter;
import br.gov.planejamento.dipla.protocolo.repositories.helper.protocolo.ProtocoloRepositoryQueries;
import br.gov.planejamento.dipla.protocolo.repositories.paginacao.PaginacaoUtil;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ProtocoloRepositoryImpl
implements ProtocoloRepositoryQueries {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private PaginacaoUtil paginacaoUtil;

    public Page<Protocolo> filtrar(ProtocoloFilter protocoloFilter, Pageable pageable) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Protocolo.class);
        this.paginacaoUtil.preparaPaginacao(criteria, pageable);
        this.adicionarFiltro(protocoloFilter, criteria);
        return new PageImpl(criteria.list(), pageable, this.total(protocoloFilter).longValue());
    }

    public Page<Protocolo> filtrarMeusProtocolos(Usuario usuario, ProtocoloFilter protocoloFilter, Pageable pageable) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Protocolo.class);
        this.paginacaoUtil.preparaPaginacao(criteria, pageable);
        this.adicionarFiltroMeusProtocolos(usuario, protocoloFilter, criteria);
        return new PageImpl(criteria.list(), pageable, this.totalMeusProtocolos(usuario, protocoloFilter).longValue());
    }

    private Long total(ProtocoloFilter protocoloFilter) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Protocolo.class);
        this.adicionarFiltro(protocoloFilter, criteria);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private Long totalMeusProtocolos(Usuario usuario, ProtocoloFilter protocoloFilter) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Protocolo.class);
        criteria.add((Criterion)Restrictions.eq((String)"usuario", (Object)usuario));
        this.adicionarFiltro(protocoloFilter, criteria);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private void adicionarFiltro(ProtocoloFilter filtro, Criteria criteria) {
        criteria.createAlias("usuario", "u");
        if (filtro != null) {
            LocalDateTime ldt;
            if (filtro.getPesquisa() != null) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)"numero", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"nupe", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"u.nome", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"u.email", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)"u.nome_social", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE)}));
            }
            if (filtro.getDesde() != null) {
                ldt = LocalDateTime.of(filtro.getDesde(), LocalTime.of(0, 0));
                Date desde = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                criteria.add((Criterion)Restrictions.ge((String)"dataHora", (Object)desde));
            }
            if (filtro.getAte() != null) {
                ldt = LocalDateTime.of(filtro.getAte(), LocalTime.of(23, 59));
                Date ate = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                criteria.add((Criterion)Restrictions.le((String)"dataHora", (Object)ate));
            }
            if (filtro.getStatus() != null) {
                if (filtro.getStatus().equals((Object)StatusEnum.APROVADO)) {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"status", (Object)StatusEnum.APROVADO), (Criterion)Restrictions.eq((String)"status", (Object)StatusEnum.PROCESSANDO)));
                } else {
                    criteria.add((Criterion)Restrictions.eq((String)"status", (Object)filtro.getStatus()));
                }
            }
        }
    }

    private void adicionarFiltroMeusProtocolos(Usuario usuario, ProtocoloFilter filtro, Criteria criteria) {
        criteria.createAlias("usuario", "u");
        criteria.add((Criterion)Restrictions.eq((String)"usuario", (Object)usuario));
        if (filtro != null) {
            LocalDateTime ldt;
            if (filtro.getPesquisa() != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"numero", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"nupe", (String)filtro.getPesquisa(), (MatchMode)MatchMode.ANYWHERE)));
            }
            if (filtro.getDesde() != null) {
                ldt = LocalDateTime.of(filtro.getDesde(), LocalTime.of(0, 0));
                Date desde = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                criteria.add((Criterion)Restrictions.ge((String)"dataHora", (Object)desde));
            }
            if (filtro.getAte() != null) {
                ldt = LocalDateTime.of(filtro.getAte(), LocalTime.of(23, 59));
                Date ate = Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
                criteria.add((Criterion)Restrictions.le((String)"dataHora", (Object)ate));
            }
            if (filtro.getStatus() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"status", (Object)filtro.getStatus()));
            }
        }
    }
}

