/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories.helper.tiposDocumento;

import br.gov.planejamento.dipla.protocolo.entities.TiposDocumento;
import br.gov.planejamento.dipla.protocolo.repositories.filter.TiposDocumentoFilter;
import br.gov.planejamento.dipla.protocolo.repositories.helper.tiposDocumento.TiposDocumentoRepositoryQueries;
import br.gov.planejamento.dipla.protocolo.repositories.paginacao.PaginacaoUtil;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

public class TiposDocumentoRepositoryImpl
implements TiposDocumentoRepositoryQueries {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private PaginacaoUtil paginacaoUtil;

    public Page<TiposDocumento> filtrar(TiposDocumentoFilter estiloFilter, Pageable pageable) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(TiposDocumento.class);
        this.paginacaoUtil.preparaPaginacao(criteria, pageable);
        this.adicionarFiltro(estiloFilter, criteria);
        return new PageImpl(criteria.list(), pageable, this.total(estiloFilter).longValue());
    }

    private Long total(TiposDocumentoFilter tiposDocumentoFilter) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(TiposDocumento.class);
        this.adicionarFiltro(tiposDocumentoFilter, criteria);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private void adicionarFiltro(TiposDocumentoFilter tiposDocumentoFilter, Criteria criteria) {
        if (tiposDocumentoFilter != null) {
            if (tiposDocumentoFilter.getCodigo() != null) {
                criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)tiposDocumentoFilter.getCodigo()));
            }
            if (!StringUtils.isEmpty((Object)tiposDocumentoFilter.getDescricao())) {
                criteria.add(Restrictions.ilike((String)"descricao", (String)tiposDocumentoFilter.getDescricao(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
    }
}

