/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories.helper.usuario;

import br.gov.planejamento.dipla.protocolo.entities.Grupo;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioBrasilCidadao;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioGrupo;
import br.gov.planejamento.dipla.protocolo.repositories.filter.UsuarioFilter;
import br.gov.planejamento.dipla.protocolo.repositories.helper.usuario.UsuarioRepositoryQueries;
import br.gov.planejamento.dipla.protocolo.repositories.paginacao.PaginacaoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.sql.JoinType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public class UsuarioRepositoryImpl
implements UsuarioRepositoryQueries {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private PaginacaoUtil paginacaoUtil;

    public Optional<Usuario> porEmailEAtivo(String email) {
        return this.manager.createQuery("from Usuario where lower(email) = lower(:email) and ativo = true", Usuario.class).setParameter("email", (Object)email).getResultList().stream().findFirst();
    }

    public List<String> permissoes(Usuario usuario) {
        return this.manager.createQuery("select distinct p.nome from Usuario u inner join u.grupos g inner join g.permissoes p where u = :usuario", String.class).setParameter("usuario", (Object)usuario).getResultList();
    }

    @Transactional(readOnly=true)
    public Page<Usuario> filtrar(UsuarioFilter filtro, Pageable pageable) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Usuario.class);
        this.paginacaoUtil.preparaPaginacao(criteria, pageable);
        this.adicionarFiltro(filtro, criteria);
        criteria.addOrder(Order.asc((String)"nome"));
        List filtrados = criteria.list();
        filtrados.forEach(u -> Hibernate.initialize((Object)u.getGrupos()));
        return new PageImpl(filtrados, pageable, this.total(filtro).longValue());
    }

    @Transactional(readOnly=true)
    public Usuario buscarComGrupos(Long codigo) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Usuario.class);
        criteria.createAlias("grupos", "g", JoinType.LEFT_OUTER_JOIN);
        criteria.add((Criterion)Restrictions.eq((String)"codigo", (Object)codigo));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return (Usuario)criteria.uniqueResult();
    }

    @Transactional(readOnly=true)
    public Optional<UsuarioBrasilCidadao> buscarBrasilCidadao(String cpf) {
        Optional<UsuarioBrasilCidadao> userBrasilCidadao = this.manager.createQuery("from UsuarioBrasilCidadao where cpf = :cpf", UsuarioBrasilCidadao.class).setParameter("cpf", (Object)cpf).getResultList().stream().findFirst();
        return userBrasilCidadao;
    }

    @Transactional(readOnly=true)
    public Boolean verificarUsuarioBrasilCidadao(Long usuario) {
        Optional id = this.manager.createQuery("select codigo from UsuarioBrasilCidadao where usuario.codigo = :usuario", Long.class).setParameter("usuario", (Object)usuario).getResultList().stream().findFirst();
        return id.isPresent();
    }

    private Long total(UsuarioFilter filtro) {
        Criteria criteria = ((Session)this.manager.unwrap(Session.class)).createCriteria(Usuario.class);
        this.adicionarFiltro(filtro, criteria);
        criteria.setProjection(Projections.rowCount());
        return (Long)criteria.uniqueResult();
    }

    private void adicionarFiltro(UsuarioFilter filtro, Criteria criteria) {
        if (filtro != null) {
            if (!StringUtils.isEmpty((Object)filtro.getNome())) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)"nome", (String)filtro.getNome(), (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)"nome_social", (String)filtro.getNome(), (MatchMode)MatchMode.ANYWHERE)));
            }
            if (!StringUtils.isEmpty((Object)filtro.getEmail())) {
                criteria.add(Restrictions.ilike((String)"email", (String)filtro.getEmail(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (filtro.getGrupos() != null && !filtro.getGrupos().isEmpty()) {
                ArrayList<Criterion> subqueries = new ArrayList<Criterion>();
                long[] lArray = filtro.getGrupos().stream().mapToLong(Grupo::getCodigo).toArray();
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long codigoGrupo = lArray[i];
                    DetachedCriteria dc = DetachedCriteria.forClass(UsuarioGrupo.class);
                    dc.add((Criterion)Restrictions.eq((String)"id.grupo.codigo", (Object)codigoGrupo));
                    dc.setProjection((Projection)Projections.property((String)"id.usuario"));
                    subqueries.add(Subqueries.propertyIn((String)"codigo", (DetachedCriteria)dc));
                }
                Criterion[] criterions = new Criterion[subqueries.size()];
                criteria.add((Criterion)Restrictions.and((Criterion[])subqueries.toArray(criterions)));
            }
        }
    }
}

