/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.repositories.paginacao;

import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@Component
public class PaginacaoUtil {
    public void preparaPaginacao(Criteria criteria, Pageable pageable) {
        int paginaAtual = pageable.getPageNumber();
        int totalRegistrosPorPagina = pageable.getPageSize();
        int primeiroRegistro = paginaAtual * totalRegistrosPorPagina;
        criteria.setFirstResult(primeiroRegistro);
        criteria.setMaxResults(totalRegistrosPorPagina);
        Sort sort = pageable.getSort();
        if (sort != null) {
            Sort.Order order = (Sort.Order)sort.iterator().next();
            String property = order.getProperty();
            criteria.addOrder(order.isAscending() ? Order.asc((String)property) : Order.desc((String)property));
        }
    }
}

