/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.security;

import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.security.LoginAttemptService;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class AppUserDetailsService
implements UserDetailsService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private LoginAttemptService loginAttemptService;

    public UserDetails loadUserByUsername(String email) throws UsernameNotFoundException {
        if (this.loginAttemptService.isBlocked(email)) {
            throw new RuntimeException("blocked");
        }
        Optional usuarioOptional = this.usuarioRepository.porEmailEAtivo(email);
        Usuario usuario = (Usuario)usuarioOptional.orElseThrow(() -> new UsernameNotFoundException("Usu\u00e1rio e/ou senha incorretos"));
        usuario.setTemPerfilAdministrador(Boolean.valueOf(this.temPerfilAdministrador(usuario)));
        return new UsuarioSistema(usuario, this.getPermissoes(usuario));
    }

    private Collection<? extends GrantedAuthority> getPermissoes(Usuario usuario) {
        HashSet authorities = new HashSet();
        List permissoes = this.usuarioRepository.permissoes(usuario);
        permissoes.forEach(p -> authorities.add(new SimpleGrantedAuthority(p.toUpperCase())));
        return authorities;
    }

    public boolean temPerfilAdministrador(Usuario usuario) {
        List permissoes = this.usuarioRepository.permissoes(usuario);
        return permissoes.stream().anyMatch(permissao -> permissao.equals("ROLE_CADASTRO"));
    }

    public boolean temPerfilBrasilCidadao(Usuario usuario) {
        List permissoes = this.usuarioRepository.permissoes(usuario);
        return permissoes.stream().anyMatch(permissao -> permissao.equals("ROLE_BRASILCIDADAO"));
    }
}

