/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.security;

import br.gov.planejamento.dipla.protocolo.entities.Configuracao;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import br.gov.planejamento.dipla.protocolo.security.GoogleResponse;
import br.gov.planejamento.dipla.protocolo.services.exeptions.ReCaptchaUnavailableException;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service(value="captchaService")
public class CaptchaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaService.class);
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private HttpServletRequest request;

    public Boolean processResponse(String response) throws ReCaptchaUnavailableException {
        LOGGER.debug("Attempting to validate response {}", (Object)response);
        URI verifyUri = URI.create(String.format("https://www.google.com/recaptcha/api/siteverify?secret=%s&response=%s&remoteip=%s", this.getReCaptchaSecret(), response, this.getClientIP()));
        try {
            RestTemplate restTemplate = new RestTemplate();
            GoogleResponse googleResponse = (GoogleResponse)restTemplate.getForObject(verifyUri, GoogleResponse.class);
            LOGGER.debug("Google's response: {} ", (Object)googleResponse.toString());
            if (!googleResponse.isSuccess()) {
                throw new ReCaptchaUnavailableException();
            }
            if (googleResponse.isSuccess()) {
                return true;
            }
        }
        catch (ReCaptchaUnavailableException e) {
            throw new ReCaptchaUnavailableException("Erro na valida\u00e7\u00e3o do captcha");
        }
        return false;
    }

    public String getReCaptchaSite() {
        return ((Configuracao)this.configuracaoRepository.findByNome(ConfiguracaoEnum.CAPTCHA_SITE_KEY.name()).get()).getValor();
    }

    public String getReCaptchaSecret() {
        return ((Configuracao)this.configuracaoRepository.findByNome(ConfiguracaoEnum.CAPTCHA_SECRET_KEY.name()).get()).getValor();
    }

    private String getClientIP() {
        String xfHeader = this.request.getHeader("X-Forwarded-For");
        if (xfHeader == null) {
            return this.request.getRemoteAddr();
        }
        return xfHeader.split(",")[0];
    }
}

