/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.security;

import br.gov.planejamento.dipla.protocolo.repositories.LoginAttemptRepository;
import br.gov.planejamento.dipla.protocolo.security.LoginAttemptService;
import br.gov.planejamento.dipla.protocolo.services.AutoCadastroService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class CustomAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    @Autowired
    private AutoCadastroService autoCadastroService;
    @Autowired
    private LoginAttemptRepository loginAttemptRepository;
    @Autowired
    private LoginAttemptService loginAttemptService;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.setDefaultFailureUrl("/login?error=true");
        String email = request.getParameter("username");
        if (exception.getMessage().equalsIgnoreCase("blocked")) {
            this.setDefaultFailureUrl("/login?erroUserBloqueado=true");
            String baseUrl = String.format("%s://%s:%d/protocolo", request.getScheme(), request.getServerName(), request.getServerPort());
            this.autoCadastroService.enviarBloqueio(email, baseUrl);
        }
        if (exception.getMessage().equalsIgnoreCase("Bad credentials")) {
            this.setDefaultFailureUrl("/login?errorBadcredencials=" + this.loginAttemptService.loginFailed(email));
        }
        super.onAuthenticationFailure(request, response, exception);
    }
}

