/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.security;

import br.gov.planejamento.dipla.protocolo.entities.LoginAttempt;
import br.gov.planejamento.dipla.protocolo.repositories.LoginAttemptRepository;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginAttemptService {
    @Autowired
    private LoginAttemptRepository loginAttemptRepository;

    public void loginSucceeded(String key) {
        String keyCodec = DigestUtils.sha1Hex((String)key);
        Optional loginAttempt = this.loginAttemptRepository.findByKey(keyCodec);
        if (loginAttempt.isPresent()) {
            this.loginAttemptRepository.delete(loginAttempt.get());
        }
    }

    public int loginFailed(String key) {
        int amount = 1;
        String keyCodec = DigestUtils.sha1Hex((String)key);
        Optional loginAttemptOptional = this.loginAttemptRepository.findByKey(keyCodec);
        if (loginAttemptOptional.isPresent()) {
            this.loginAttemptRepository.setFixedAmountFor(Integer.valueOf(amount += ((LoginAttempt)loginAttemptOptional.get()).getAmount().intValue()), new Date(), keyCodec);
        } else {
            this.loginAttemptRepository.insertLogginAttempt(keyCodec);
        }
        return amount;
    }

    public boolean isBlocked(String key) {
        String keyCodec = DigestUtils.sha1Hex((String)key);
        Optional loginAttemptOptional = this.loginAttemptRepository.findByKey(keyCodec);
        if (loginAttemptOptional.isPresent()) {
            return ((LoginAttempt)loginAttemptOptional.get()).getAmount() >= 3;
        }
        return false;
    }
}

