/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.sei.ws;

import Sei.Assunto;
import Sei.Documento;
import Sei.Interessado;
import Sei.Procedimento;
import Sei.RetornoConsultaProcedimento;
import Sei.RetornoGeracaoProcedimento;
import Sei.SeiBindingStub;
import br.gov.planejamento.dipla.protocolo.entities.ConfiguracaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.ArquivosRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import br.gov.planejamento.dipla.protocolo.services.SalvarProtocoloService;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class SeiWSClient {
    @Autowired
    private Mailer mailer;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private SalvarProtocoloService salvarProtocoloService;
    @Autowired
    private ArquivosRepository arquivosRepository;
    @Autowired
    private ArquivoStorage arquivoStorage;

    private String getDateTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = new Date();
        return dateFormat.format(date);
    }

    @Async
    public String enviar(Protocolo protocolo, Long idUsuario, String sei, String tipo) {
        if (sei != null && tipo != null && !sei.isEmpty() && tipo.equals("existente")) {
            this.enviarDocumento(protocolo, idUsuario, sei);
        } else {
            try {
                URL urlEndpoint = new URL(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_ENDPOINT));
                SeiBindingStub seiBindingStub = new SeiBindingStub(urlEndpoint, null);
                seiBindingStub.setTimeout(36000000);
                Procedimento procedimento = new Procedimento();
                if (tipo.equals("novo")) {
                    procedimento.setNumeroProtocolo(sei);
                    procedimento.setDataAutuacao(this.getDateTime());
                }
                procedimento.setAssuntos(this.recuperaAssunto());
                procedimento.setEspecificacao(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.PROCEDIMENTO_ESPECIFICADO));
                Interessado interessado = new Interessado();
                interessado.setNome(protocolo.getUsuario().getNome());
                interessado.setSigla("Telefone: " + protocolo.getUsuario().getTelefone());
                Interessado[] interessados = new Interessado[]{interessado};
                procedimento.setInteressados(interessados);
                procedimento.setNivelAcesso(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.PROCEDIMENTO_NIVEL_ACESSO));
                procedimento.setIdTipoProcedimento(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.PROCEDIMENTO_ID_TIPO_PROCEDIMENTO));
                List arquivosList = this.arquivosRepository.findByProtocolo(protocolo);
                procedimento.setObservacao(protocolo.toString() + "\nQuantidade Arquivos: " + arquivosList.size());
                RetornoGeracaoProcedimento retornoGeracaoProcedimento = seiBindingStub.gerarProcedimento(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SIGLA_SISTEMA), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.IDENTIFICACAO_SERVICO), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ID_UNIDADE), procedimento, null, null, null, "N", "N", null, null, "N", null, null);
                arquivosList.forEach(arquivo -> {
                    try {
                        Documento documento = new Documento();
                        documento.setIdProcedimento(retornoGeracaoProcedimento.getProcedimentoFormatado().replace(".", "").replace("/", "").replace("-", ""));
                        documento.setObservacao(protocolo.toString());
                        documento.setDescricao(arquivo.getDescricaoDocumento());
                        documento.setNomeArquivo(arquivo.getNomeOriginal());
                        documento.setTipo(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.DOCUMENTO_TIPO));
                        documento.setIdSerie(arquivo.getTipoDocumento().getCodigoSei());
                        documento.setData(protocolo.getDataFormatada());
                        documento.setNivelAcesso(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.DOCUMENTO_NIVEL_ACESSO));
                        Path path = FileSystems.getDefault().getPath(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.STORAGE_PATH), new String[0]).resolve(arquivo.getNome());
                        documento.setConteudo(Base64Utils.encodeToString((byte[])FileUtils.readFileToByteArray((File)path.toFile())));
                        seiBindingStub.incluirDocumento(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SIGLA_SISTEMA), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.IDENTIFICACAO_SERVICO), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ID_UNIDADE), documento);
                    }
                    catch (IOException e) {
                        protocolo.setErroWs("[ERRO INCLUIR DOCUMENTO] " + e.getMessage());
                        throw new RuntimeException(e.getMessage());
                    }
                });
                protocolo.setLinkSEI(retornoGeracaoProcedimento.getLinkAcesso());
                protocolo.setNupe(retornoGeracaoProcedimento.getProcedimentoFormatado());
                this.salvarProtocoloService.aprovar(protocolo, idUsuario);
                protocolo.setArquivosList(arquivosList);
                this.mailer.enviarAceite(protocolo);
                return retornoGeracaoProcedimento.getProcedimentoFormatado();
            }
            catch (Exception e) {
                protocolo.setErroWs("[ERRO GERAR PROCEDIMENTO] " + e.getMessage());
                e.printStackTrace();
                this.rollback(protocolo, e.getMessage());
            }
        }
        return null;
    }

    private Assunto[] recuperaAssunto() {
        Assunto assunto = new Assunto();
        assunto.setCodigoEstruturado(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ASSUNTO_CODIGO_ESTRUTURADO));
        Assunto[] assuntos = new Assunto[]{assunto};
        return assuntos;
    }

    private void rollback(Protocolo protocolo, String msgErro) {
        protocolo.setNupe(null);
        this.salvarProtocoloService.pendente(protocolo);
        this.mailer.enviarEmailErroEnvioSEI(protocolo, msgErro);
    }

    public String enviarDocumento(Protocolo protocolo, Long idUsuario, String sei) {
        String observacaoAnterior = "";
        try {
            URL urlEndpoint = new URL(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_ENDPOINT));
            SeiBindingStub seiBindingStub = new SeiBindingStub(urlEndpoint, null);
            seiBindingStub.setTimeout(36000000);
            List arquivosList = this.arquivosRepository.findByProtocolo(protocolo);
            arquivosList.forEach(arquivo -> {
                try {
                    Documento documento = new Documento();
                    documento.setIdProcedimento(sei.replace(".", "").replace("/", "").replace("-", ""));
                    documento.setObservacao(protocolo.toString());
                    documento.setDescricao(arquivo.getDescricaoDocumento());
                    documento.setNomeArquivo(arquivo.getNomeOriginal());
                    documento.setTipo(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.DOCUMENTO_TIPO));
                    documento.setIdSerie(arquivo.getTipoDocumento().getCodigoSei());
                    documento.setData(protocolo.getDataFormatada());
                    documento.setNivelAcesso(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.DOCUMENTO_NIVEL_ACESSO));
                    Path path = FileSystems.getDefault().getPath(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.STORAGE_PATH), new String[0]).resolve(arquivo.getNome());
                    documento.setConteudo(Base64Utils.encodeToString((byte[])FileUtils.readFileToByteArray((File)path.toFile())));
                    seiBindingStub.incluirDocumento(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SIGLA_SISTEMA), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.IDENTIFICACAO_SERVICO), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ID_UNIDADE), documento);
                }
                catch (IOException e) {
                    protocolo.setErroWs("[ERRO INCLUIR DOCUMENTO] " + e.getMessage());
                    throw new RuntimeException(e.getMessage());
                }
            });
            protocolo.setNupe(sei);
            this.salvarProtocoloService.aprovar(protocolo, idUsuario);
            protocolo.setArquivosList(this.arquivosRepository.findByProtocolo(protocolo));
            this.mailer.enviarAceite(protocolo);
            return sei;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rollback(protocolo, e.getMessage());
            return null;
        }
    }

    public RetornoConsultaProcedimento consultarProtocoloSei(String sei) {
        Optional<Object> retorno = Optional.ofNullable(null);
        RetornoConsultaProcedimento retornoConsultaProcedimento = new RetornoConsultaProcedimento();
        try {
            URL urlEndpoint = new URL(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.URL_ENDPOINT));
            SeiBindingStub seiBindingStub = new SeiBindingStub(urlEndpoint, null);
            retornoConsultaProcedimento = seiBindingStub.consultarProcedimento(this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.SIGLA_SISTEMA), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.IDENTIFICACAO_SERVICO), this.configuracaoRepository.recuperarValor(ConfiguracaoEnum.ID_UNIDADE), sei, "S", "S", "S", "S", "S", "S", "S", "S", "S");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retornoConsultaProcedimento;
    }
}

