/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.dto.UsuarioBrasilCidadaoDto;
import br.gov.planejamento.dipla.protocolo.entities.AcaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Grupo;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioBrasilCidadao;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.GrupoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.LoginAttemptRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ProtocoloRepository;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioBrasilCidadaoRepository;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.services.LogProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.exeptions.EmailUsuarioJaCadastradoException;
import br.gov.planejamento.dipla.protocolo.services.exeptions.SenhaObrigatoriaUsuarioException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

@Service
public class AutoCadastroService {
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private ProtocoloRepository protocoloRepository;
    @Autowired
    private LoginAttemptRepository loginAttemptRepository;
    @Autowired
    private GrupoRepository grupoRepository;
    @Autowired
    private LogProtocoloService logProtocoloService;
    @Autowired
    private UsuarioBrasilCidadaoRepository usuarioBrasilCidadaoRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private Mailer mailer;

    @Transactional
    public void salvar(Usuario usuario) {
        ArrayList<Object> grupos = new ArrayList<Object>();
        grupos.add(this.grupoRepository.findOne((Serializable)Long.valueOf(2L)));
        this.salvar(usuario, grupos, Boolean.valueOf(false), Boolean.valueOf(true));
    }

    @Transactional
    public void salvar(Usuario usuario, List<Grupo> grupos, Boolean ativo, Boolean enviarEmail) {
        usuario.setGrupos(grupos);
        Optional usuarioExistente = this.usuarioRepository.findByEmail(usuario.getEmail());
        if (usuarioExistente.isPresent() && !((Usuario)usuarioExistente.get()).equals((Object)usuario)) {
            throw new EmailUsuarioJaCadastradoException("E-mail j\u00e1 cadastrado");
        }
        if (usuario.isNovo() && StringUtils.isEmpty((Object)usuario.getSenha())) {
            throw new SenhaObrigatoriaUsuarioException("Senha \u00e9 obrigat\u00f3ria para novo usu\u00e1rio");
        }
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
        usuario.setConfirmacaoSenha(usuario.getSenha());
        usuario.setAtivo(ativo);
        Usuario usuarioSalvo = (Usuario)this.usuarioRepository.saveAndFlush((Object)usuario);
        this.logProtocoloService.saveLog((Object)usuarioSalvo, AcaoEnum.INSERIR);
        String hash = Base64Utils.encodeToString((byte[])String.valueOf(usuario.getCodigo()).getBytes());
        usuarioSalvo.setUrlConfirmacaoCadastro(usuario.getUrlConfirmacaoCadastro() + "/" + hash);
        if (enviarEmail.booleanValue()) {
            this.mailer.enviarConfirmacaoCadastro(usuarioSalvo);
        }
    }

    @Transactional
    public void cadastrarBrasilCidadao(UsuarioBrasilCidadaoDto usuarioretorno) {
        UsuarioBrasilCidadao usuarioBrasilCidadao = new UsuarioBrasilCidadao();
        Usuario usuario = new Usuario();
        usuario.setNome(usuarioretorno.getNome());
        usuario.setEmail(usuarioretorno.getEmail());
        usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuarioretorno.getCpf()));
        usuario.setTelefone(usuarioretorno.getTelefone() == null || usuarioretorno.getTelefone().isEmpty() ? "(00)00000-0000" : usuarioretorno.getTelefone().trim());
        ArrayList<Object> grupos = new ArrayList<Object>();
        grupos.add(this.grupoRepository.findOne((Serializable)Long.valueOf(3L)));
        usuario.setGrupos(grupos);
        this.salvar(usuario, grupos, Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public void migrarBrasilCidadao(UsuarioBrasilCidadaoDto usuarioretorno) {
        UsuarioBrasilCidadao usuarioBrasilCidadao = new UsuarioBrasilCidadao();
        usuarioBrasilCidadao.setCpf(usuarioretorno.getCpf());
        usuarioBrasilCidadao.setToken(usuarioretorno.getToken());
        usuarioBrasilCidadao.setAtivo(Boolean.FALSE);
        this.usuarioBrasilCidadaoRepository.save((Object)usuarioBrasilCidadao);
    }

    public void atualizarBrasilCidadao(UsuarioBrasilCidadaoDto usuarioretorno, UsuarioBrasilCidadao usuarioBrasilCidadao, Boolean atualizaEmail) {
        Usuario userMp = usuarioBrasilCidadao.getUsuario();
        userMp.setNome(usuarioretorno.getNome());
        if (atualizaEmail.booleanValue()) {
            userMp.setEmail(usuarioretorno.getEmail());
        }
        userMp.setSenha(this.passwordEncoder.encode((CharSequence)usuarioretorno.getCpf()));
        userMp.setTelefone(usuarioretorno.getTelefone() == null || usuarioretorno.getTelefone().isEmpty() ? "(00)00000-0000" : usuarioretorno.getTelefone().trim());
        ArrayList<Object> grupos = new ArrayList<Object>();
        grupos.add(this.grupoRepository.findOne((Serializable)Long.valueOf(3L)));
        this.salvar(userMp, grupos, userMp.getAtivo(), Boolean.valueOf(false));
    }

    @Transactional
    public void confirmarCadastro(String hash) {
        String decoded = new String(Base64Utils.decode((byte[])hash.getBytes()));
        Long codigo = Long.parseLong(decoded);
        Usuario usuarioExistente = (Usuario)this.usuarioRepository.findOne((Serializable)codigo);
        usuarioExistente.setAtivo(Boolean.TRUE);
        this.usuarioRepository.saveAndFlush((Object)usuarioExistente);
    }

    @Transactional
    public void confirmarDesbloqueio(String hash) {
        Optional loginAttempt = this.loginAttemptRepository.findByKey(hash);
        if (loginAttempt.isPresent()) {
            this.loginAttemptRepository.delete(loginAttempt.get());
        }
    }

    @Transactional
    public void confirmarConciliacao(String hashBrasilCidadao, String hashEmail) {
        String decodedBrasilCidadao = new String(Base64Utils.decode((byte[])hashBrasilCidadao.getBytes())).substring(2);
        String decodedEmail = new String(Base64Utils.decode((byte[])hashEmail.getBytes()));
        Long codigoBrasilCidadao = Long.parseLong(decodedBrasilCidadao);
        Optional usuarioExistenteProtocolo = this.usuarioRepository.findByEmail(decodedEmail);
        UsuarioBrasilCidadao usuarioExistenteBrasilCidadao = (UsuarioBrasilCidadao)this.usuarioBrasilCidadaoRepository.findOne((Serializable)codigoBrasilCidadao);
        if (usuarioExistenteProtocolo.isPresent()) {
            List protocoloList;
            if (!((Usuario)usuarioExistenteProtocolo.get()).equals((Object)usuarioExistenteBrasilCidadao.getUsuario()) && (protocoloList = this.protocoloRepository.findByUsuario(usuarioExistenteBrasilCidadao.getUsuario())) != null) {
                protocoloList.forEach(p -> p.setUsuario((Usuario)usuarioExistenteProtocolo.get()));
                this.protocoloRepository.save((Iterable)protocoloList);
            }
            ((Usuario)usuarioExistenteProtocolo.get()).setAtivo(Boolean.TRUE);
            ArrayList<Object> grupos = new ArrayList<Object>();
            grupos.add(this.grupoRepository.findOne((Serializable)Long.valueOf(3L)));
            ((Usuario)usuarioExistenteProtocolo.get()).setGrupos(grupos);
            usuarioExistenteBrasilCidadao.setUsuario((Usuario)usuarioExistenteProtocolo.get());
            usuarioExistenteBrasilCidadao.setAtivo(Boolean.TRUE);
            this.usuarioRepository.save(usuarioExistenteProtocolo.get());
            this.usuarioBrasilCidadaoRepository.save((Object)usuarioExistenteBrasilCidadao);
        } else {
            Usuario usuarioEmail = usuarioExistenteBrasilCidadao.getUsuario();
            usuarioEmail.setEmail(decodedEmail);
            this.usuarioRepository.save((Object)usuarioEmail);
        }
    }

    @Transactional
    public void enviarConsiliacaoUsuario(UsuarioBrasilCidadao usuarioBrasilCidadao, String email, String baseUrl) {
        Optional usuarioExistente = this.usuarioRepository.findByEmail(email);
        if (usuarioExistente.isPresent()) {
            Random gerador = new Random();
            String hashBrasilCidadao = Base64Utils.encodeToString((byte[])String.valueOf(gerador.toString().substring(0, 2) + usuarioBrasilCidadao.getCodigo()).getBytes());
            String hashEmail = Base64Utils.encodeToString((byte[])String.valueOf(email).getBytes());
            ((Usuario)usuarioExistente.get()).setUrlConfirmacaoCadastro(baseUrl + "/usuarios/auto-brasil-cidadao/" + hashBrasilCidadao + "/" + hashEmail);
            this.mailer.enviarConsiliacaoUsuario((Usuario)usuarioExistente.get(), email);
        }
    }

    @Transactional
    public void enviarBloqueio(String email, String baseUrl) {
        String keyCodec = DigestUtils.sha1Hex((String)email);
        Optional usuarioExistente = this.usuarioRepository.findByEmail(email);
        if (usuarioExistente.isPresent()) {
            String hashEmail = Base64Utils.encodeToString((byte[])String.valueOf(email).getBytes());
            ((Usuario)usuarioExistente.get()).setUrlDesbloqueio(baseUrl + "/usuarios/auto-desbloqueio/" + keyCodec);
            this.mailer.enviarDesbloqueio((Usuario)usuarioExistente.get(), email);
        }
    }
}

