/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.config.BrasilCidadaoConfig;
import br.gov.planejamento.dipla.protocolo.dto.TokenRetornoDto;
import br.gov.planejamento.dipla.protocolo.dto.UsuarioBrasilCidadaoDto;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioBrasilCidadao;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.security.BrasilCidadaoUserDetails;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BrasilCidadaoService {
    private String msgErro = null;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private BrasilCidadaoConfig brasilCidadaoOpenIdConnectConfig;

    public UsuarioBrasilCidadaoDto autenticarBrasilCidadao(String code) throws Exception {
        UsuarioBrasilCidadaoDto usuarioretorno = new UsuarioBrasilCidadaoDto();
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        HttpEntity entityToken = new HttpEntity((Object)this.brasilCidadaoOpenIdConnectConfig.gerarRequisicaoAtributo(code), (MultiValueMap)this.brasilCidadaoOpenIdConnectConfig.gerarRequisicaoHeader());
        ResponseEntity respEntToken = restTemplate.exchange(this.brasilCidadaoOpenIdConnectConfig.gerarUrlToken(), HttpMethod.POST, entityToken, String.class, new Object[0]);
        if (respEntToken.getStatusCodeValue() != 200) {
            throw new Exception("Erro no recebimento do token");
        }
        TokenRetornoDto retorno = (TokenRetornoDto)new ObjectMapper().readValue(((String)respEntToken.getBody()).toString(), TokenRetornoDto.class);
        ResponseEntity respEntUsuario = restTemplate.exchange(this.brasilCidadaoOpenIdConnectConfig.gerarUrlDadosUsuarios(retorno.getAccess_token()), HttpMethod.GET, null, String.class, new Object[0]);
        if (respEntUsuario.getStatusCodeValue() != 200) {
            throw new Exception("Erro no recebimento dos dados do usuario");
        }
        usuarioretorno = (UsuarioBrasilCidadaoDto)new ObjectMapper().readValue(((String)respEntUsuario.getBody()).toString(), UsuarioBrasilCidadaoDto.class);
        usuarioretorno.setToken(retorno.getAccess_token());
        return usuarioretorno;
    }

    public UsernamePasswordAuthenticationToken autenticarProtocolo(UsuarioBrasilCidadaoDto usuarioretorno) throws Exception {
        Optional usuarioBrasilCidadao = this.usuarioRepository.buscarBrasilCidadao(usuarioretorno.getCpf());
        BrasilCidadaoUserDetails userDetails = new BrasilCidadaoUserDetails(((UsuarioBrasilCidadao)usuarioBrasilCidadao.get()).getUsuario().getEmail());
        Optional usuario = this.usuarioRepository.findByEmail(((UsuarioBrasilCidadao)usuarioBrasilCidadao.get()).getUsuario().getEmail());
        List permissoes = this.usuarioRepository.permissoes((Usuario)usuario.get());
        ((Usuario)usuario.get()).setTemPerfilBrasilCidadao(Boolean.valueOf(true));
        UsuarioSistema usuarioSistema = new UsuarioSistema((Usuario)usuario.get(), this.getPermissoes(), Boolean.valueOf(true));
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)usuarioSistema, (Object)usuarioretorno.getToken(), this.getPermissoes());
        return auth;
    }

    private Collection<? extends GrantedAuthority> getPermissoes() {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_BRASILCIDADAO"));
        return authorities;
    }
}

