/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.entities.AcaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.UsuarioRepository;
import br.gov.planejamento.dipla.protocolo.services.LogProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.StatusUsuario;
import br.gov.planejamento.dipla.protocolo.services.exeptions.EmailUsuarioJaCadastradoException;
import br.gov.planejamento.dipla.protocolo.services.exeptions.SenhaObrigatoriaUsuarioException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class CadastroUsuarioService {
    @Autowired
    private LogProtocoloService logProtocoloService;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private Mailer mailer;

    @Transactional
    public void salvar(Usuario usuario) {
        Usuario usuarioExistente;
        AcaoEnum acao = null;
        Optional usuarioEmailExistente = this.usuarioRepository.findByEmail(usuario.getEmail());
        if (usuarioEmailExistente.isPresent() && !((Usuario)usuarioEmailExistente.get()).equals((Object)usuario)) {
            throw new EmailUsuarioJaCadastradoException("E-mail j\u00e1 cadastrado");
        }
        if (usuario.isNovo() && StringUtils.isEmpty((Object)usuario.getSenha())) {
            throw new SenhaObrigatoriaUsuarioException("Senha \u00e9 obrigat\u00f3ria para novo usu\u00e1rio");
        }
        if (usuario.isNovo() || !StringUtils.isEmpty((Object)usuario.getSenha())) {
            usuario.setSenha(this.passwordEncoder.encode((CharSequence)usuario.getSenha()));
            usuario.setAtivo(Boolean.TRUE);
        } else if (StringUtils.isEmpty((Object)usuario.getSenha())) {
            usuarioExistente = (Usuario)this.usuarioRepository.findOne((Serializable)usuario.getCodigo());
            usuario.setSenha(usuarioExistente.getSenha());
        }
        usuario.setConfirmacaoSenha(usuario.getSenha());
        if (!usuario.isNovo()) {
            usuarioExistente = (Usuario)this.usuarioRepository.findOne((Serializable)usuario.getCodigo());
            if (usuario.getAtivo() == null) {
                usuario.setAtivo(usuarioExistente.getAtivo());
            }
        }
        acao = usuario.isNovo() ? AcaoEnum.INSERIR : AcaoEnum.ALTERAR;
        this.usuarioRepository.saveAndFlush((Object)usuario);
        this.logProtocoloService.saveLog((Object)usuario, acao);
    }

    @Transactional
    public void alterarStatus(Long[] codigos, StatusUsuario statusUsuario) {
        statusUsuario.executar(codigos, this.usuarioRepository);
    }

    @Transactional
    public void excluir(Usuario usuario) {
        this.usuarioRepository.delete((Object)usuario);
    }

    @Transactional
    public void reiniciarSenha(Usuario usuario) {
        Optional usuarioOptional = this.usuarioRepository.findByEmail(usuario.getEmail());
        if (usuarioOptional.isPresent()) {
            Boolean userBrasilCidadao = this.usuarioRepository.verificarUsuarioBrasilCidadao(((Usuario)usuarioOptional.get()).getCodigo());
            if (userBrasilCidadao == null || userBrasilCidadao.booleanValue()) {
                throw new RuntimeException("Usu\u00e1rio Cadastrado como Brasil Cidad\u00e3o.");
            }
        } else {
            throw new RuntimeException("Email n\u00e3o cadastrado.");
        }
        Usuario usuarioRecuperado = (Usuario)usuarioOptional.get();
        String senha = this.generatePassword();
        usuarioRecuperado.setSenha(this.passwordEncoder.encode((CharSequence)senha));
        this.usuarioRepository.save((Object)usuarioRecuperado);
        usuario.setSenha(senha);
        this.mailer.enviarNovaSenha(usuario);
    }

    private String generatePassword() {
        return new BigInteger(130, new SecureRandom()).toString(32);
    }
}

