/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.entities.Configuracao;
import br.gov.planejamento.dipla.protocolo.repositories.ConfiguracaoRepository;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfiguracaoService {
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;

    public void salvar(Configuracao configuracao) {
        Optional configuracaoOptional = this.configuracaoRepository.findByNome(configuracao.getNome());
        if (configuracaoOptional.isPresent()) {
            this.configuracaoRepository.delete(configuracaoOptional.get());
        }
        this.configuracaoRepository.save((Object)configuracao);
    }

    @Transactional
    public void editar(Configuracao configuracao) {
        Optional configuracaoSave = this.configuracaoRepository.findByCodigo(configuracao.getCodigo());
        ((Configuracao)configuracaoSave.get()).setValor(configuracao.getValor());
        ((Configuracao)configuracaoSave.get()).setDescricao(configuracao.getDescricao());
        this.configuracaoRepository.save(configuracaoSave.get());
    }

    public void excluir(Configuracao configuracao) {
        this.configuracaoRepository.delete((Object)configuracao);
    }
}

