/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import Sei.RetornoConsultaProcedimento;
import br.gov.planejamento.dipla.protocolo.dto.ArquivoDTO;
import br.gov.planejamento.dipla.protocolo.entities.AcaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.StatusEnum;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.ArquivosRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ProtocoloRepository;
import br.gov.planejamento.dipla.protocolo.sei.ws.SeiWSClient;
import br.gov.planejamento.dipla.protocolo.services.LogProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.SalvarProtocoloService;
import br.gov.planejamento.dipla.protocolo.services.event.AprovarProtocoloEvent;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class EnviarProtocoloService {
    @Autowired
    private SalvarProtocoloService salvarProtocoloService;
    @Autowired
    private ProtocoloRepository protocoloRepository;
    @Autowired
    private LogProtocoloService logProtocoloService;
    @Autowired
    private ArquivosRepository arquivosRepository;
    @Autowired
    private Mailer mailer;
    @Autowired
    private SeiWSClient seiWSClient;
    @Autowired
    private ApplicationEventPublisher publisher;

    public void enviar(Protocolo protocolo, List<ArquivoDTO> arquivoDTOList) {
        protocolo.setDataEnvio(new Date());
        this.salvarProtocoloService.save(protocolo, arquivoDTOList);
        this.mailer.enviarConfirmacao(protocolo);
    }

    public Optional<String> consultarSei(String sei) {
        RetornoConsultaProcedimento retornoConsultaProcedimento = this.seiWSClient.consultarProtocoloSei(sei);
        return Optional.of(retornoConsultaProcedimento.getLinkAcesso());
    }

    public void enviarSEI(Protocolo protocolo, String sei, String tipo) {
        protocolo.setDataEnvio(new Date());
        protocolo.setNupe("Processando...");
        protocolo.setStatus(StatusEnum.PROCESSANDO);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR);
        this.publisher.publishEvent((ApplicationEvent)new AprovarProtocoloEvent((Object)this, protocolo, this.logProtocoloService.recuperarUsuario(), sei, tipo));
    }

    public void recusar(Protocolo protocolo) {
        this.salvarProtocoloService.reprovar(protocolo);
        this.mailer.enviarRecusa(protocolo);
    }

    public void reenviarRecibo(Protocolo protocolo, String email) {
        StatusEnum status = protocolo.getStatus();
        protocolo.setArquivosList(this.arquivosRepository.findByProtocolo(protocolo));
        if (email.isEmpty() || email != null) {
            protocolo.setInteressado(email);
        }
        if (status.equals((Object)StatusEnum.APROVADO)) {
            this.mailer.enviarAceite(protocolo);
        }
        if (status.equals((Object)StatusEnum.REPROVADO)) {
            this.mailer.enviarRecusa(protocolo);
        }
        if (status.equals((Object)StatusEnum.PENDENTE)) {
            this.mailer.enviarConfirmacao(protocolo);
        }
        if (status.equals((Object)StatusEnum.APROVADO_MANUALMENTE)) {
            this.mailer.enviarAceite(protocolo);
        }
    }
}

