/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.entities.AcaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Arquivos;
import br.gov.planejamento.dipla.protocolo.entities.EntidadeEnum;
import br.gov.planejamento.dipla.protocolo.entities.LogSistema;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.TiposDocumento;
import br.gov.planejamento.dipla.protocolo.entities.Usuario;
import br.gov.planejamento.dipla.protocolo.entities.UsuarioBrasilCidadao;
import br.gov.planejamento.dipla.protocolo.repositories.LogStatusRepository;
import br.gov.planejamento.dipla.protocolo.security.UsuarioSistema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogProtocoloService {
    @Autowired
    private LogStatusRepository logStatusRepository;

    @Transactional
    public void saveLog(Object object, AcaoEnum acao) {
        if (this.recuperarUsuario() != null) {
            this.saveLog(object, acao, this.recuperarUsuario());
        } else {
            this.saveLog(object, acao, Long.valueOf(0L));
        }
    }

    @Transactional
    public void saveLog(Object object, AcaoEnum acao, Long idUsuario) {
        LogSistema logSistema = new LogSistema();
        if (object instanceof Protocolo) {
            logSistema.carregarLog(((Protocolo)object).getCodigo(), EntidadeEnum.PROTOCOLO, acao, "teste", object.toString(), idUsuario);
        }
        if (object instanceof Usuario) {
            logSistema.carregarLog(((Usuario)object).getCodigo(), EntidadeEnum.USUARIO, acao, "teste", object.toString(), idUsuario);
        }
        if (object instanceof UsuarioBrasilCidadao) {
            logSistema.carregarLog(((UsuarioBrasilCidadao)object).getCodigo(), EntidadeEnum.USUARIO_BRASIL_CIDADAO, acao, "teste", object.toString(), idUsuario);
        }
        if (object instanceof TiposDocumento) {
            logSistema.carregarLog(((TiposDocumento)object).getCodigo(), EntidadeEnum.TIPO_DOCUMENTO, acao, "teste", object.toString(), idUsuario);
        }
        if (object instanceof Arquivos) {
            logSistema.carregarLog(((Arquivos)object).getCodigo(), EntidadeEnum.ARQUIVO, acao, "teste", object.toString(), idUsuario);
        }
        this.logStatusRepository.save((Object)logSistema);
    }

    public Long recuperarUsuario() {
        Long idUser = null;
        try {
            Object usuariologado = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            idUser = ((UsuarioSistema)usuariologado).getUsuario().getCodigo();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idUser;
    }
}

