/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.services;

import br.gov.planejamento.dipla.protocolo.dto.ArquivoDTO;
import br.gov.planejamento.dipla.protocolo.entities.AcaoEnum;
import br.gov.planejamento.dipla.protocolo.entities.Arquivos;
import br.gov.planejamento.dipla.protocolo.entities.Protocolo;
import br.gov.planejamento.dipla.protocolo.entities.StatusEnum;
import br.gov.planejamento.dipla.protocolo.entities.TiposDocumento;
import br.gov.planejamento.dipla.protocolo.mail.Mailer;
import br.gov.planejamento.dipla.protocolo.repositories.ArquivosRepository;
import br.gov.planejamento.dipla.protocolo.repositories.ProtocoloRepository;
import br.gov.planejamento.dipla.protocolo.repositories.TiposDocumentoRepository;
import br.gov.planejamento.dipla.protocolo.services.LogProtocoloService;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalvarProtocoloService {
    @Autowired
    private ArquivoStorage arquivoStorage;
    @Autowired
    private Mailer mailer;
    @Autowired
    private ArquivosRepository arquivosRepository;
    @Autowired
    private ProtocoloRepository protocoloRepository;
    @Autowired
    private LogProtocoloService logProtocoloService;
    @Autowired
    private TiposDocumentoRepository tipoDocumentoRepository;

    @Transactional
    public void save(Protocolo protocolo, List<ArquivoDTO> arquivoDTOList) {
        ArrayList arquivosList = new ArrayList();
        arquivoDTOList.forEach(arquivoDTO -> {
            this.arquivoStorage.salvar(arquivoDTO.getNome());
            Arquivos arquivo = new Arquivos();
            arquivo.setContentType(arquivoDTO.getContentType());
            arquivo.setNome(arquivoDTO.getNome());
            arquivo.setNomeOriginal(arquivoDTO.getNomeOriginal());
            arquivo.setTamanho(arquivoDTO.getTamanho());
            arquivo.setTipoDocumento((TiposDocumento)this.tipoDocumentoRepository.findOne((Serializable)Long.valueOf(Long.parseLong(arquivoDTO.getCodigoTipoDocumento()))));
            arquivo.setDescricaoDocumento(arquivoDTO.getDescricaoDocumento());
            arquivo.setProtocolo(protocolo);
            arquivosList.add(arquivo);
        });
        protocolo.setNumero(this.gerarNumeroProtocolo());
        protocolo.setDataHora(new Date());
        protocolo.setArquivosList(arquivosList);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.INSERIR);
    }

    @Transactional
    public void aprovar(Protocolo protocolo, Long idUsuario) {
        protocolo.setStatus(StatusEnum.APROVADO);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR, idUsuario);
    }

    @Transactional
    public void aprovarManualmente(Protocolo protocolo) {
        protocolo.setStatus(StatusEnum.APROVADO_MANUALMENTE);
        protocolo.setArquivosList(this.arquivosRepository.findByProtocolo(protocolo));
        this.protocoloRepository.save((Object)protocolo);
        this.mailer.enviarAceite(protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR);
    }

    @Transactional
    public void reprovar(Protocolo protocolo) {
        protocolo.setStatus(StatusEnum.REPROVADO);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR);
    }

    @Transactional
    public void analisando(Protocolo protocolo) {
        protocolo.setStatus(StatusEnum.ANALISANDO);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR);
    }

    @Transactional
    public void pendente(Protocolo protocolo) {
        protocolo.setStatus(StatusEnum.PENDENTE);
        this.protocoloRepository.save((Object)protocolo);
        this.logProtocoloService.saveLog((Object)protocolo, AcaoEnum.ALTERAR);
    }

    private String gerarNumeroProtocolo() {
        LocalDateTime hoje = LocalDateTime.now();
        Date d = new Date();
        String prot = String.valueOf(d.getTime()).replaceAll("(\\d{4})(\\d{4})(\\d{5})", "$1.$2.$3/" + hoje.getYear());
        return prot;
    }
}

