/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.storage;

import br.gov.planejamento.dipla.protocolo.dto.ArquivoDTO;
import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

public class ArquivoStorageRunnable
implements Runnable {
    private final MultipartFile[] files;
    private final DeferredResult<ArquivoDTO> deferredResult;
    private final ArquivoStorage arquivoStorage;

    public ArquivoStorageRunnable(MultipartFile[] files, DeferredResult<ArquivoDTO> deferredResult, ArquivoStorage arquivoStorage) {
        this.files = files;
        this.deferredResult = deferredResult;
        this.arquivoStorage = arquivoStorage;
    }

    @Override
    public void run() {
        String nomeArquivo = this.arquivoStorage.salvarTemporariamente(this.files);
        String contentType = this.files[0].getContentType();
        String nomeOriginal = this.files[0].getOriginalFilename();
        double s = this.files[0].getSize();
        double divisor = 1024.0;
        double size = BigDecimal.valueOf(s / divisor).setScale(2, RoundingMode.FLOOR).doubleValue();
        NumberFormat nf = NumberFormat.getInstance(new Locale("pt", "BR"));
        this.deferredResult.setResult((Object)new ArquivoDTO(nomeOriginal, nomeArquivo, contentType, this.getLogoArquivo(nomeArquivo), nf.format(size)));
    }

    private String getLogoArquivo(String nomeArquivo) {
        if (nomeArquivo.endsWith("pdf")) {
            return "logos/pdf-logo.png";
        }
        if (nomeArquivo.endsWith("docx") || nomeArquivo.endsWith("doc")) {
            return "logos/word-logo.png";
        }
        if (nomeArquivo.endsWith("txt")) {
            return "logos/txt-logo.png";
        }
        if (nomeArquivo.endsWith("zip")) {
            return "logos/zip-logo.png";
        }
        if (nomeArquivo.endsWith("png") || nomeArquivo.endsWith("jpg") || nomeArquivo.endsWith("jpeg") || nomeArquivo.endsWith("bmp")) {
            return "logos/img-logo.png";
        }
        return "";
    }
}

