/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.storage.local;

import br.gov.planejamento.dipla.protocolo.storage.ArquivoStorage;
import br.gov.planejamento.dipla.protocolo.util.MyStringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class ArquivoStorageLocal
implements ArquivoStorage {
    @Autowired
    private MyStringUtil myStringUtil;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArquivoStorageLocal.class);
    private Path local;
    private Path localTemporario;
    private Path localLogo;

    public ArquivoStorageLocal(Path local) {
        this.local = local;
        this.criarPastas();
    }

    public String salvarTemporariamente(MultipartFile[] files) {
        String novoNome = null;
        if (files != null && files.length > 0) {
            MultipartFile arquivo = files[0];
            novoNome = this.renomearArquivo(this.myStringUtil.removerCaracteresEspeciais(arquivo.getOriginalFilename()));
            try {
                arquivo.transferTo(new File(this.localTemporario.toAbsolutePath().toString() + FileSystems.getDefault().getSeparator() + novoNome));
            }
            catch (IOException e) {
                throw new RuntimeException("Erro salvando o arquivo na pasta tempor\u00e1ria", e);
            }
        }
        return novoNome;
    }

    public byte[] recuperarFotoTemporaria(String nome) {
        try {
            return Files.readAllBytes(this.localTemporario.resolve(nome));
        }
        catch (IOException e) {
            throw new RuntimeException("Erro lendo o arquivo tempor\u00e1ria", e);
        }
    }

    public byte[] recuperarLogo(String nome) {
        try {
            return Files.readAllBytes(this.localLogo.resolve(nome));
        }
        catch (IOException e) {
            throw new RuntimeException("Erro lendo o arquivo tempor\u00e1ria", e);
        }
    }

    public void salvar(String arquivo) {
        try {
            Files.move(this.localTemporario.resolve(arquivo), this.local.resolve(arquivo), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Erro movendo o arquivo para destino final", e);
        }
    }

    public byte[] recuperar(String nome) {
        try {
            return Files.readAllBytes(this.local.resolve(nome));
        }
        catch (IOException e) {
            throw new RuntimeException("Erro lendo o arquivo", e);
        }
    }

    public void excluir(String arquivo) {
        try {
            Files.deleteIfExists(this.local.resolve(arquivo));
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Erro apagando foto '%s'. Mensagem: %s", arquivo, e.getMessage()));
        }
    }

    public void excluirTemporario(String arquivo) {
        try {
            Files.deleteIfExists(this.localTemporario.resolve(arquivo));
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Erro apagando foto '%s'. Mensagem: %s", arquivo, e.getMessage()));
        }
    }

    private void criarPastas() {
        try {
            Files.createDirectories(this.local, new FileAttribute[0]);
            this.localTemporario = FileSystems.getDefault().getPath(this.local.toString(), "temp");
            this.localLogo = FileSystems.getDefault().getPath(this.local.toString(), "logos");
            Files.createDirectories(this.localTemporario, new FileAttribute[0]);
            Files.createDirectories(this.localLogo, new FileAttribute[0]);
            ClassLoader loader = this.getClass().getClassLoader();
            this.copyFile(loader.getResource("static/images/pdf-logo.png").toString().replaceAll("file:/", ""), this.localLogo.toAbsolutePath().toString());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Pastas criadas para salvar arquivos.");
                LOGGER.debug("Pasta default: " + this.local.toAbsolutePath());
                LOGGER.debug("Pasta tempor\u00e1ria: " + this.localTemporario.toAbsolutePath());
            }
            this.excluirTodosTemporarios();
        }
        catch (IOException e) {
            throw new RuntimeException("Erro criando pasta para salvar arquivo", e);
        }
    }

    private void excluirTodosTemporarios() {
        try {
            FileUtils.cleanDirectory((File)this.localTemporario.toFile());
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Erro Mensagem: %s", e.getMessage()));
        }
    }

    private void copyFile(String filePath, String dir) {
        Path sourceFile = Paths.get(filePath, new String[0]);
        Path targetDir = Paths.get(dir, new String[0]);
        Path targetFile = targetDir.resolve(sourceFile.getFileName());
        try {
            Files.copy(sourceFile, targetFile, new CopyOption[0]);
        }
        catch (FileAlreadyExistsException ex) {
            System.err.format("File %s already exists.", targetFile);
        }
        catch (IOException ex) {
            System.err.format("I/O Error when copying file", new Object[0]);
        }
    }

    private String renomearArquivo(String nomeOriginal) {
        String novoNome = UUID.randomUUID().toString() + "_" + nomeOriginal;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Nome original: %s, novo nome: %s", nomeOriginal, novoNome));
        }
        return novoNome;
    }
}

