/*
 * Decompiled with CFR 0.152.
 */
package br.gov.planejamento.dipla.protocolo.validation.validator;

import br.gov.planejamento.dipla.protocolo.validation.AtributoConfirmacao;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;

public class AtributoConfirmacaoValidator
implements ConstraintValidator<AtributoConfirmacao, Object> {
    private String atributo;
    private String atributoConfirmacao;

    public void initialize(AtributoConfirmacao constraintAnnotation) {
        this.atributo = constraintAnnotation.atributo();
        this.atributoConfirmacao = constraintAnnotation.atributoConfirmacao();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        boolean valido = false;
        try {
            String valorAtributo = BeanUtils.getProperty((Object)object, (String)this.atributo);
            String valorAtributoConfirmacao = BeanUtils.getProperty((Object)object, (String)this.atributoConfirmacao);
            valido = this.ambosSaoNull((Object)valorAtributo, (Object)valorAtributoConfirmacao) || this.ambosSaoIguais((Object)valorAtributo, (Object)valorAtributoConfirmacao);
        }
        catch (Exception e) {
            throw new RuntimeException("Erro recuperando valores dos atributos", e);
        }
        if (!valido) {
            context.disableDefaultConstraintViolation();
            String mensagem = context.getDefaultConstraintMessageTemplate();
            ConstraintValidatorContext.ConstraintViolationBuilder violationBuilder = context.buildConstraintViolationWithTemplate(mensagem);
            violationBuilder.addPropertyNode(this.atributoConfirmacao).addConstraintViolation();
        }
        return valido;
    }

    private boolean ambosSaoIguais(Object valorAtributo, Object valorAtributoConfirmacao) {
        return valorAtributo != null && valorAtributo.equals(valorAtributoConfirmacao);
    }

    private boolean ambosSaoNull(Object valorAtributo, Object valorAtributoConfirmacao) {
        return valorAtributo == null && valorAtributoConfirmacao == null;
    }
}

