var Protocolo = Protocolo || {};

Protocolo.UploadArquivo = (function () {

    function UploadArquivo() {
        this.inputNomeArquivo = $('#nome-arquivo');
        this.inputContentType = $('#content-type');
        this.inputTamanho = $('#tamanho-arquivo');
        this.inputUUID = $('input[name=uuid]');
        this.labelNomeArquivo = $(".js-nome-arquivo");
        this.btnAnexar = $(".js-btn-anexar");
        this.nomeArquivoOriginal = $('#nome-original');
        this.comboTipoDocumento = $("#tipo-documento");
        this.inputDescricaoDocumento = $('#descricao-documento');
        this.inputUploadSelect = $('#upload-select');
        this.btnSelecione = $('.upload-text-file');
        this.btnEnviar = $('.js-btn-enviar');

        
        this.containerArquivosAdicionados = $("#container-arquivos-adicionados");

        this.htmlThumbnailArquivoTemplate = $('#imagem-arquivo').html();
        this.template = Handlebars.compile(this.htmlThumbnailArquivoTemplate);

        this.htmlTabelaListaArquivosTemplate = $('#tabela-lista-arquivos').html();
        this.tabelaListaArquivostemplate = Handlebars.compile(this.htmlTabelaListaArquivosTemplate);

        this.containerThumbnailArquivo = $('.js-container-imagem-arquivo');

        this.uploadDrop = $('#upload-drop');
        this.btnAnexar.on('click', onBtnAnexar.bind(this));

        this.imgLoading = $('.js-img-loading');

        this.radioProtocoloAnterior = $('.js-radio-protocolo-anterior');

        this.divProtocoloAnterior = $('#divProtocoloAnterior');
        this.inputNumeroProtocoloAnterior = $('#numero-protocolo');
        this.hiddenPossuiProtocoloAnterior = $('#possui-protocolo-anterior');
    }

    UploadArquivo.prototype.iniciar = function () {
        var settings = {
            type: 'json',
            allow: '*.(pdf)',
            filelimit: 1,
            action: this.containerThumbnailArquivo.data('url-arquivos'),
            complete: onUploadCompleto.bind(this),
            error: onUploadErro.bind(this),
            beforeSend: adicionarCsrfToken,
            loadstart: onLoadStart.bind(this)
        };
        UIkit.uploadSelect($('#upload-select'), settings);
        UIkit.uploadDrop(this.uploadDrop, settings);
        listaArquivosAdicionados.call(this);
        
        if (this.inputNomeArquivo.val()) {
            renderizarThumbnailArquivo.call(this, {
                nome: this.inputNomeArquivo.val(),
                tamanho: this.inputTamanho.val(),
                contentType: this.inputContentType.val(),
                nomeOriginal: this.nomeArquivoOriginal.val()
            });
        } else{
        	this.btnAnexar.prop("disabled", true);
            this.btnEnviar.prop("disabled", false);
        }

        this.radioProtocoloAnterior.on('click', onRAdioProtocoloAnteriorClick.bind(this));

        if (this.hiddenPossuiProtocoloAnterior.val() === 'S') {
            mostraProtocoloAnterior.call(this);
        } else {
            escondeProtocoloAnterior.call(this);
        }

    };

    function onRAdioProtocoloAnteriorClick(event) {
        var radio = $(event.currentTarget);
        if (radio.val() === 'S') {
            mostraProtocoloAnterior.call(this);
        } else {
            escondeProtocoloAnterior.call(this);
        }
    }

    function mostraProtocoloAnterior() {
        this.divProtocoloAnterior.removeClass('hidden');
        this.hiddenPossuiProtocoloAnterior.val('S');
        var radio = $('#radio-possui-protocolo-n');
        radio.prop('checked', true);
        this.inputNumeroProtocoloAnterior.focus();
    }

    function escondeProtocoloAnterior() {
        this.hiddenPossuiProtocoloAnterior.val('N');
        this.divProtocoloAnterior.addClass('hidden');
        var radio = $('#radio-possui-protocolo-s');
        radio.prop('checked', true);
    }

    function onLoadStart() {
        this.imgLoading.removeClass('hidden');
        this.btnSelecione.addClass('hidden');
    }

    function listaArquivosAdicionados() {
        $.ajax({
            url: this.containerArquivosAdicionados.data('action'),
            method: 'GET',
            contentType: 'application/json',
            success: onListarAnexosConcluido.bind(this),
            error: onErroListarAnexo.bind(this)
        });

    }

    function bindBtnExcluirArquivoSelecionado() {
        var btnExcluirArquivoSelecionado = $('.js-btn-excluir-arquivo');
        btnExcluirArquivoSelecionado.on('click', onBtnExcluirArquivoSelecionado.bind(this));
        return btnExcluirArquivoSelecionado;
    }

    function onUploadCompleto(resposta) {
   		renderizarThumbnailArquivo.call(this, resposta);
    }
    function temArquivoDuplicado(resposta,nomeNovo){
    	var nomeNovo = nomeNovo;
    	var tamanhoNovo =resposta.tamanho;
    	var limparUpload=false;
    	arquivos = $('.js-cliente-pesquisa-rapida');
    	$('.js-cliente-pesquisa-rapida').each(function() {
    		var nome = $(this).find('td[data-nome]').data('nome');
    		var tamanho = $(this).find('td[data-tamanho]').data('tamanho');
    		if ((nomeNovo==nome)&&(tamanhoNovo==tamanho)){
    			onErroArquivoDuplicado();
    			$('.js-img-loading').addClass('hidden');
    			limparUpload=true;
    			return ;
    		} 
    		});
    	if(limparUpload){
    		$('.js-imagem-arquivo').remove();
			this.imgLoading.addClass('hidden');
			limparAtributosUpload.call(this);
			
    	}
    }
    

    function onUploadErro(resposta) {
        $.jAlert({
            'title': 'Erro',
            'content': resposta.message,
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }
    function onErroArquivoDuplicado() {
        $.jAlert({
            'title': 'Erro',
            'content': 'Arquivo já foi adcionado!',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    function renderizarThumbnailArquivo(resposta) {
        this.imgLoading.addClass('hidden');
        this.btnSelecione.removeClass('hidden');
        if (resposta.tamanho == undefined) {
            limparAtributosUpload.call(this);
            $.jAlert({
                'title': 'Erro',
                'content': resposta.message,
                'theme': 'dark_red',
                'btns': {'text': 'FECHAR'}
            });
        }else {

            this.inputNomeArquivo.val(resposta.nome);
            this.inputContentType.val(resposta.contentType);
            this.inputTamanho.val(resposta.tamanho);
            this.nomeArquivoOriginal.val(resposta.nomeOriginal);

            this.uploadDrop.addClass('hidden');

            var logo = resposta.logo;

            var tamanho = resposta.tamanho;
            
            var nomeDefinitivo=resposta.nomeOriginal;
            
            if (resposta.nomeOriginal.length>100){
            	nomeDefinitivo = nomeDefinitivo.slice(0,90)+"..."+nomeDefinitivo.slice(93,96)+'.pdf';
        	}
                        
            var htmlThumbnailArquivo = this.template({
                arquivo: logo,
                nome: nomeDefinitivo + " (" + tamanho + ") Kb",
            });
            this.containerThumbnailArquivo.append(htmlThumbnailArquivo);

            this.nomeArquivoOriginal.val(nomeDefinitivo);
            
            $('.js-remove-arquivo').on('click', onRemoverArquivo.bind(this));

            this.btnAnexar.prop("disabled", false);
            this.btnEnviar.prop("disabled", true);

            
            temArquivoDuplicado.call(this,resposta,nomeDefinitivo);
        }
    }


    function onRemoverArquivo(evento) {
        $('.js-imagem-arquivo').remove();
        limparAtributosUpload.call(this);
    }

    function limparAtributosUpload() {
    	$('#upload-drop').removeClass('hidden');
        this.inputUploadSelect.val(null);
        this.inputNomeArquivo.val('');
        this.inputContentType.val('');
        this.inputTamanho.val('');
        this.inputDescricaoDocumento.val('');
        this.comboTipoDocumento.val('');
        this.labelNomeArquivo.text('Arquivo');
        this.btnAnexar.prop("disabled", true);
        this.btnEnviar.prop("disabled", false);
    }

    function onBtnAnexar(event) {
        event.preventDefault();
        if (this.inputNomeArquivo.val() && this.comboTipoDocumento.find('option:selected').val()) {
            $.ajax({
                url: this.btnAnexar.data('action'),
                method: 'POST',
                contentType: 'application/json',
                data: JSON.stringify({
                    uuid: this.inputUUID.val(),
                    nome: this.inputNomeArquivo.val(),
                    nomeOriginal: this.nomeArquivoOriginal.val(),
                    tamanho: this.inputTamanho.val(),
                    tipoDocumento: this.comboTipoDocumento.find('option:selected').text(),
                    descricaoDocumento: this.inputDescricaoDocumento.val(),
                    codigoTipoDocumento: this.comboTipoDocumento.find('option:selected').val(),
                    contentType: this.inputContentType.val()
                }),
                success: onAnexoConcluida.bind(this),
                error: onErroAnexo.bind(this)
            });
        } else {
            $.jAlert({
                'title': 'Erro',
                'content': 'Selecione um tipo de documento.',
                'theme': 'dark_red',
                'btns': {'text': 'FECHAR'}
            });
        }
    }

    function onAnexoConcluida() {
        $.ajax({
            url: this.containerArquivosAdicionados.data('action'),
            method: 'GET',
            contentType: 'application/json',
            success: onListarAnexosConcluido.bind(this),
            error: onErroListarAnexo.bind(this)
        });

        this.inputUploadSelect.val('');

        $('.js-imagem-arquivo').remove();
        limparAtributosUpload.call(this);
    }

    function onErroAnexo(resposta) {
        var responseObject = jQuery.parseJSON(resposta.responseText);
        $.jAlert({
            'title': 'Erro',
            'content': responseObject.message,
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    function onListarAnexosConcluido(resposta) {
        var html = this.tabelaListaArquivostemplate(resposta);
        this.containerArquivosAdicionados.html(html);
        bindBtnExcluirArquivoSelecionado.call(this);
    }

    function onErroListarAnexo(resposta) {
        var responseObject = jQuery.parseJSON(resposta.responseText);
        $.jAlert({
            'title': 'Erro',
            'content': responseObject.message,
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    function onBtnExcluirArquivoSelecionado(event) {
        event.preventDefault();
        var nomeArquivoExclusao = $(event.currentTarget).data("nome");
        var url = this.containerArquivosAdicionados.data('action') + "?nome=" + nomeArquivoExclusao;

        $.ajax({
            url: url,
            method: 'DELETE',
            contentType: 'application/json',
            success: onExclusaoSucesso.bind(this),
            error: onExclusaoErro.bind(this)
        });
    }

    function onExclusaoSucesso() {
        $.ajax({
            url: this.containerArquivosAdicionados.data('action'),
            method: 'GET',
            contentType: 'application/json',
            success: onListarAnexosConcluido.bind(this),
            error: onErroListarAnexo.bind(this)
        });
    }

    function onExclusaoErro(resposta) {
        var responseObject = jQuery.parseJSON(resposta.responseText);
        $.jAlert({
            'title': 'Erro',
            'content': responseObject.message,
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    function adicionarCsrfToken(xhr) {
        var token = $('input[name=_csrf]').val();
        var header = $('input[name=_csrf_header]').val();
        xhr.setRequestHeader(header, token);
    }

    return UploadArquivo;

})();

$(function () {
    var uploadArquivo = new Protocolo.UploadArquivo();
    uploadArquivo.iniciar();
});
