var Protocolo = Protocolo || {};

Protocolo.ListaArquivos = (function () {

    function ListaArquivos() {
        this.lnkArquivos = $('.js-lnk-arquivos');

        this.htmlTabelaListaArquivosTemplate = null;
        this.tabelaListaArquivostemplate = null;

        this.containerArquivosListados = null;

    }

    ListaArquivos.prototype.iniciar = function () {
        this.lnkArquivos.on('click', onShowTabelaListaArquivosModal.bind(this));
    };

    function onShowTabelaListaArquivosModal(e) {
        var campo = $.base64.encode((Math.random() * 100) + '|' + e.currentTarget['id'] + '|' + Math.random());
        $.ajax({
            url: '/protocolo/arquivos/protocolo/',
            method: 'GET',
            contentType: 'application/json',
            data : {
                htr : campo
            },
            success: onListaArquivoConcluida.bind(this),
            error: onListaArquivoErro.bind(this)
        });
    }

    function onListaArquivoConcluida(resposta) {

        this.containerArquivosListados = $('#container-arquivos-listados');
        this.htmlTabelaListaArquivosTemplate = $('#tabela-lista-arquivos-modal').html();
        this.tabelaListaArquivostemplate = Handlebars.compile(this.htmlTabelaListaArquivosTemplate);

        var html = this.tabelaListaArquivostemplate(resposta);
        this.containerArquivosListados.html(html);

        var $modal = $('#modalListaArquivos');
        $modal.on('hidden.bs.modal', onHideModalListaArquivos.bind(this));

        $modal.modal();

        var telaAprovarReprovar = new Protocolo.TelaAprovarReprovar();
        telaAprovarReprovar.iniciar();

    }

    function onHideModalListaArquivos() {
        $('#modalListaArquivos').remove();
    }

    function onListaArquivoErro() {
        $.jAlert({
            'title': 'Erro',
            'content': 'Erro ao obter a lista de aquivos.',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    return ListaArquivos;
})();

Protocolo.TelaAprovarReprovar = (function () {

    function TelaAprovarReprovar() {
        this.idProtocolo = $('.js-lista-arquivos-codigo-protocolo').data('codigo-protocolo');
        this.btnAprovarModal = $('.js-btn-modal-aprovar');
        this.btnAprovarManualModal = $('.js-btn-modal-aprovar-manual');
        this.btnReprovarModal = $('.js-btn-modal-reprovar');
        this.textAreaObservacao = $('#obs-tela-modal');
        this.tipoFormulario = $('.js-formulario').data('tipo-formulario');
        this.containerObservacao = $('.js-container-observacao');
    }

    TelaAprovarReprovar.prototype.iniciar = function () {
        this.btnAprovarModal.on('click', onClickBtnAprovarModal.bind(this));
        this.btnAprovarManualModal.on('click', onClickconsultaSei.bind(this));
        this.btnReprovarModal.on('click', onClickBtnReprovarModal.bind(this));

        if (this.tipoFormulario === 'reprovacao') {
            this.btnReprovarModal.addClass('hidden');
            this.containerObservacao.addClass('hidden');
        } else {
            this.btnReprovarModal.removeClass('hidden');
            this.containerObservacao.removeClass('hidden');
        }
    }

    function onClickBtnAprovarModal() {

        this.numeroProtocoloSei = $('.numero_protocolo_sei').val();
        this.tipoProtocolo = $("input[name='radio_protocolo']:checked").val();
        if ((this.tipoProtocolo=='novo'||this.tipoProtocolo=='existente')&&this.numeroProtocoloSei==''){
        	swal("Error", "Informe o numero do SEI obrigatório", "error");
        }else{
	        swal({
	            title: 'Confirma o aceite deste Protocolo?',
	            text: 'Uma vez aprovado não será possível desfazer a operação',
	            showCancelButton: true,
	            confirmButtonColor: '#54dd6d',
	            confirmButtonText: 'SIM',
	            cancelButtonText: 'CANCELAR',
	            closeOnEsc: false,
	            closeOnConfirm: true
	        }, onConfirmarAprovacao.bind(this));
        }
    }
    
    
    function onClickconsultaSei() {
    	this.numeroProtocoloSei = $('.numero_protocolo_sei').val();
    	if (this.numeroProtocoloSei!=''){
    		$.ajax({
                url: this.btnAprovarManualModal.data('url') + this.numeroProtocoloSei,
                method: 'GET',
                contentType: 'application/json',
                success: onConfirmarAprovacaoManual.bind(this),
                error: function (data) {
                	swal("Error", "Numero do protocolo não localizado no SEI", "error");
                },
            });
    	}else{
    		swal("Error", "Numero do protocolo no SEI é obrigatório", "error");
    	}
    	
    }
    
    function onConfirmarAprovacao() {
        $.ajax({
            url: this.btnAprovarModal.data('url') + this.idProtocolo + '?sei=' + this.numeroProtocoloSei+'&tipo='+ this.tipoProtocolo,
            method: 'PUT',
            contentType: 'application/json',
            success: onBtnAprovarModalSucesso.bind(this),
            error: onBtnAprovarModalErro.bind(this)
        });

    }
    
    function onConfirmarAprovacaoManual() {
    	this.numeroProtocoloSei = $('.numero_protocolo_sei').val();
        swal({
            title: 'Confirma o aceite deste Protocolo Manualmente?',
            text: 'Uma vez aprovado não será possível desfazer a operação',
			showCancelButton: true,
			confirmButtonColor: '#54dd6d',
			confirmButtonText: 'SIM',
			cancelButtonText: 'CANCELAR',
			closeOnEsc: false,
			closeOnConfirm: true
        }, 
        onExecutarAprovacaoManual.bind(this));
    }
    
   function onExecutarAprovacaoManual(){
        $.ajax({
            url: this.btnAprovarManualModal.data('url') + this.numeroProtocoloSei +'/'+ this.idProtocolo ,
            method: 'PUT',
            contentType: 'application/json',
            success: onBtnAprovarModalSucesso.bind(this),
            error: onBtnAprovarModalErro.bind(this)
        });
    }

    function onBtnAprovarModalSucesso() {
    	$.jAlert({
            'title': 'Sucesso',
            'closeOnEsc':false,
            'closeBtn':false,
            'content': 'Protocolo enviado para processamento no SEI.',
            'theme': 'blue',
            'btns': {
                'text': 'FECHAR',
                'onClick': function () {
                    window.location.reload();
                }
            }
        });
    }

    function onBtnAprovarModalErro() {
    	$.jAlert({
            'title': 'Erro',
            'closeOnEsc':false,
            'closeBtn':false,
            'content': 'Erro ao aprovar protocolo.',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR',
            	'onClick': function () {
                    window.location.reload();
                }
        	}
        });
    }

    function onClickBtnReprovarModal() {
        //event.preventDefault();
        if (this.textAreaObservacao.val().length === 0) {
            $.jAlert({
                'title': 'Erro',
                'content': 'O preenchimento da observação é obrigatório.',
                'theme': 'dark_red',
                'btns': {'text': 'FECHAR'}
            });
        } else {
            swal({
                title: 'Confirma a recusa deste Protocolo?',
                text: 'Poderá ser aprovado novamente na aba Protocolos Reprovados',
                showCancelButton: true,
                confirmButtonColor: '#DD6B55',
                confirmButtonText: 'SIM',
                cancelButtonText: 'CANCELAR',
                closeOnConfirm: true
            }, onConfirmarReprovacao.bind(this));
        }
    }

    function onConfirmarReprovacao() {
        if (this.textAreaObservacao.val()) {
            $.ajax({
                url: this.btnReprovarModal.data('url') + this.idProtocolo,
                method: 'PUT',
                contentType: 'application/json',
                data: this.textAreaObservacao.val(),
                success: onBtnReprovarModalSucesso.bind(this),
                error: onBtnReprovarModalErro.bind(this)
            });
        } else {
            var containerMsgErro = $('.js-erro-tela-lista-arquivos-modal');
            containerMsgErro.removeClass('hidden');
            containerMsgErro.html('<span>Favor preencher o campo observação para recusar um protocolo.</span>');
        }

    }

    function onBtnReprovarModalSucesso() {
        $.jAlert({
            'title': 'Sucesso',
            'closeOnEsc':false,
            'closeBtn':false,
            'content': 'Protocolo recusado com sucesso.',
            'theme': 'blue',
            'btns': {
                'text': 'FECHAR',
                'onClick': function () {
                    window.location.reload();
                }
            }
        });
    }

    function onBtnReprovarModalErro() {
        $.jAlert({
            'title': 'Erro',
            'closeOnEsc':false,
            'closeBtn':false,
            'content': 'Erro ao recusar protocolo. Verifique ',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR',
            	'onClick': function () {
                    window.location.reload();
                }
        	}
        });
    }

    return TelaAprovarReprovar;

})();

$(function () {
    var dashboard = new Protocolo.ListaArquivos();
    dashboard.iniciar();
});

EnvioSEI = {
    atuzalizarFlag : function (id) {
        $.ajax({
            type: "PUT",
            url: 'atualizarFlag/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
            },
            error: function (data) {
            },
        });
    },

    buscarFlag : function (id) {
        $.ajax({
            type: "GET",
            url: 'buscarFlag/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
                //console.log(data.data.status);
                if(data.data.status == "ANALISANDO"){
                    alert("O protocolo já está em processo de análise!")
                    window.location.reload();
                }else{
                    EnvioSEI.atuzalizarFlag(id);
                }
            },
            error: function (data) {
                console.log("Erro inesperado");
            },
        });
    },

    buscarFlagParaFechar : function (id) {
        $.ajax({
            type: "GET",
            url: 'buscarFlag/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
                //console.log(data.data.status);
                if(data.data.status == "ANALISANDO"){
                    EnvioSEI.atuzalizarFlagPendente(id);
                }
            },
            error: function (data) {
                console.log("Erro inesperado");
            },
        });
    },

    buscarFlagParaFecharReprovacao : function (id) {
        $.ajax({
            type: "GET",
            url: 'buscarFlag/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
                //console.log(data.data.status);
                if(data.data.status == "ANALISANDO"){
                    //console.log("hayaaaa")
                    EnvioSEI.atuzalizarFlagReprovado(id);
                }
            },
            error: function (data) {
                console.log("Erro inesperado");
            },
        });
    },

    atuzalizarFlagPendente : function (id) {
        $.ajax({
            type: "PUT",
            url: 'atuzalizarFlagPendente/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
                window.location.reload();
            },
            error: function (data) {
                window.location.reload();
            },
        });
    },

    atuzalizarFlagReprovado : function (id) {
        $.ajax({
            type: "PUT",
            url: 'atuzalizarFlagReprovado/'+id,
            dataType: 'json',
            charset: 'utf-8',
            success: function (data) {
                window.location.reload();
            },
            error: function (data) {
                window.location.reload();
            },
        });
    },


}

$( document ).ready(function() {

    $( ".js-btn-open-modal" ).click(function() {
        EnvioSEI.buscarFlag($(this).attr('id'));
    });

});
