var Protocolo = Protocolo || {};

Protocolo.MaskMoney = (function () {

    function MaskMoney() {
        this.decimal = $('.js-decimal');
        this.plain = $('.js-plain');
    }

    MaskMoney.prototype.enable = function () {
        this.decimal.maskMoney({
            decimal: ',',
            thousands: '.'
        });
        this.plain.maskMoney({
            precision: 0,
            thousands: '.'
        });
    };

    return MaskMoney;

}());

Protocolo.MaskPhoneNumber = (function () {

    function MaskPhoneNumber() {
        this.inputPhoneNumber = $('.js-phone-number');
    }

    MaskPhoneNumber.prototype.enable = function () {
        var maskBehavior = function (val) {
            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        };

        var options = {
            onKeyPress: function (val, e, field, options) {
                field.mask(maskBehavior.apply({}, arguments), options);
            }
        };

        this.inputPhoneNumber.mask(maskBehavior, options);
    };

    return MaskPhoneNumber;

}());

Protocolo.MaskCep = (function () {

    function MaskCep() {
        this.inputCep = $('.js-cep');
    }

    MaskCep.prototype.enable = function () {
        this.inputCep.mask('00.000-000');
    };

    return MaskCep;

}());

Protocolo.MaskNumber = (function () {

    function MaskNumber() {
        this.inputNumber = $('.js-number');
    }

    MaskNumber.prototype.enable = function () {
        this.inputNumber.mask('00000000');
    };

    return MaskNumber;

}());

Protocolo.MaskCPF = (function () {

    function MaskCPF() {
        this.inputCpf = $('.js-cpf');
    }

    MaskCPF.prototype.enable = function () {
        this.inputCpf.mask('000.000.000/00');
    };

    return MaskCPF;

}());

Protocolo.MaskDate = (function () {

    function MaskDate() {
        this.inputDate = $('.js-date');
    }

    MaskDate.prototype.enable = function () {
        this.inputDate.mask('00/00/0000');
        this.inputDate.datepicker({
            orientation: 'bottom',
            language: 'pt-BR',
            autoclose: true
        });
    };

    return MaskDate;

}());

Protocolo.Security = (function () {

    function Security() {
        this.token = $('input[name=_csrf]').val();
        this.header = $('input[name=_csrf_header]').val();
    }

    Security.prototype.enable = function () {
        $(document).ajaxSend(function (event, jqxhr, settings) {
            jqxhr.setRequestHeader(this.header, this.token);
        }.bind(this));
    };

    return Security;

}());

numeral.language('pt-br');

Protocolo.formatarMoeda = function (valor) {
    return numeral(valor).format('0,0.00');
};

Protocolo.recuperarValor = function (valorFormatado) {
    return numeral().unformat(valorFormatado);
};

$(function () {
    var maskMoney = new Protocolo.MaskMoney();
    maskMoney.enable();

    var maskPhoneNumber = new Protocolo.MaskPhoneNumber();
    maskPhoneNumber.enable();

    var maskCep = new Protocolo.MaskCep();
    maskCep.enable();

    var maskCPF = new Protocolo.MaskCPF();
    maskCPF.enable();

    var maskNumber = new Protocolo.MaskNumber();
    maskNumber.enable();

    var maskDate = new Protocolo.MaskDate();
    maskDate.enable();

    var security = new Protocolo.Security();
    security.enable();

});

function process_date(date){
    var parts = date.split("/");
    return new Date(parts[2], parts[1] - 1, parts[0]).getTime();
}

$( document ).ready(function() {
    $( ".end-date" ).change(function() {
        var start_date = $( ".start-date" ).val();
        var end_date = $(this).val();

        if( (process_date(end_date) < process_date(start_date)))
        {
            alert("O período final deve ser maior que o período inicial");
            $(this).val("")
        }
    });

    $( ".start-date" ).change(function() {
        var start_date = $(this).val();
        var end_date = $( ".end-date" ).val();

        if( (process_date(end_date) < process_date(start_date)))
        {
            alert("O período final deve ser maior que o período inicial");
            $(this).val("")
        }
    });
});

function validateEmail(email) {
	var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    var result = re.test(String(email).toLowerCase());
    return result;
}

function podeEnviar(input){
	if(input===''){
		return true;
	}else if (input===false){ 
		return false;
	}else 
		return validateEmail(input);
		
}

EnvioEmail = {
		reenvioRecibo : function (id) {
			swal({
				  title: "Reenvio de recibo por email!",
				  text: "Deseja informar novo interessado:",
				  type: "input",
				  inputPlaceholder: "E-mail:",
				  confirmButtonText: "Enviar",
				  showCancelButton: true,
				  closeOnConfirm: false,
				  showLoaderOnConfirm: true
			}, function (inputValue) {
				if(podeEnviar(inputValue)){
					$.ajax({
					    type: "GET",
					    url: 'reenvioRecibo/'+id+'?email='+inputValue,
					    dataType: 'json',
					    charset: 'utf-8',
					    success: function (data) {
					    	swal("Email enviado", " para:  " + data.data +".", "success");
					    },
					    error: function (data) {
					    	swal("Error", " houve algum erro no envio do email! " + inputValue +".", "error");
					    },
					});
				}else{
					swal.showInputError("Informe um email valido!");
				}					
			});
		}
}

function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

function setCookie(cname, cvalue) {
    var d = new Date();
    d.setTime(d.getTime() + (350000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

$( document ).ready(function() {

    $( ".js-btn-reenvio-protocolo" ).click(function() {
    	EnvioEmail.reenvioRecibo($(this).attr('id'));
    });
    $( ".btn-fechar-modal-brasil-cidadao" ).click(function() {
    	setCookie("fecharModal", "true");
    });
    gerenciarPopUp();

});

function gerenciarPopUp() {
	var fecharModal = getCookie("fecharModal");
	if(fecharModal==''){
    	$("#modalMigracaoBrasilCidadao").modal("show");
	}
}

