var Protocolo = Protocolo || {};

Protocolo.TabelaTiposDocumento = (function () {

    function TabelaTiposDocumento() {
        this.btnExcluirTiposDocumento = $('.js-btn-excluir-tipos-documento');
    }

    TabelaTiposDocumento.prototype.iniciar = function () {
        this.btnExcluirTiposDocumento.on('click', onExcluirTiposDocumento.bind(this));
    };


    function onExcluirTiposDocumento(event) {
        event.preventDefault();
        var url = $(event.currentTarget).data("url");
        swal({
            title: 'Confirma a Exclusão ?',
            text: 'Você não poderá recuperar depois.',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'SIM',
            cancelButtonText: 'CANCELAR',
            closeOnConfirm: false
        }, onExcluirConfirmado.bind(this, url));
    }

    function onExcluirConfirmado(url) {
        $.ajax({
            url: url,
            method: 'DELETE',
            contentType: 'application/json',
            success: onExclusaoConcluido.bind(this),
            error: onErroExclusao.bind(this)
        });
    }
    
    function onExclusaoConcluido() {
        window.location.reload();
    }
    
    function onErroExclusao() {
        $.jAlert({
            'title': 'Erro',
            'content': 'Erro ao excluir o tipo de documento. Já existe vínculo com protocolo existente',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });        
    }

    return TabelaTiposDocumento;

})();

$(function () {
    var tabelaTiposDocumento = new Protocolo.TabelaTiposDocumento();
    tabelaTiposDocumento.iniciar();
});