var Protocolo = Protocolo || {};

Protocolo.TabelaUsuarios = (function () {

    function TabelaUsuarios() {
        this.btnExcluir = $('.js-btn-excluir-usuario');
    }

    TabelaUsuarios.prototype.iniciar = function () {
        this.btnExcluir.on('click', onExcluirUsuario.bind(this));
    };

    function onExcluirUsuario(event) {
        event.preventDefault();        
        var url = $(event.currentTarget).data('url');
        console.log(url);
        swal({
            title: 'Confirma a Exclusão ?',
            text: 'Você não poderá recuperar depois.',
            showCancelButton: true,
            confirmButtonColor: '#DD6B55',
            confirmButtonText: 'SIM',
            cancelButtonText: 'CANCELAR',
            closeOnConfirm: false
        }, onExcluirConfirmado.bind(this, url));
    }

    function onExcluirConfirmado(url) {
        $.ajax({
            url: url,
            method: 'DELETE',
            contentType: 'application/json',
            success: onExclusaoConcluido.bind(this),
            error: onErroExclusao.bind(this)
        });
    }

    function onExclusaoConcluido() {
        window.location.reload();
    }

    function onErroExclusao() {
        $.jAlert({
            'title': 'Erro',
            'content': 'Erro ao excluir o usuário.',
            'theme': 'dark_red',
            'btns': {'text': 'FECHAR'}
        });
    }

    return TabelaUsuarios;
})();

$(function () {
    var tabelaUsuarios = new Protocolo.TabelaUsuarios();
    tabelaUsuarios.iniciar();
});
