<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

class AvaliacaoController extends GxController {

    public   $titulo = 'Avaliao do Auditor';

    public function actionAdmin($id = 0) {

        if (!empty($id)) {
            $this->subtitulo = 'Atualizar';
            $model = $this->loadModel($id , 'Avaliacao');
        } else {
            $this->subtitulo = 'Inserir';
            $model = new Avaliacao;
        }
        
        if (isset($_POST['Avaliacao'])) {
            $model->relatorio_fk = $_GET['relatorio'];
            $model->unidade_administrativa_fk = $_GET['sureg'];
            $model->usuario_fk = $_GET['auditor'];
            $model->data = date("Y-m-d");
            $model->nome_login = Yii::app()->user->login;

             // salva avaliao   
             if ($model->save()) {

                  // salva notas
                  $notas = Avaliacao::model()->SalvaNotas($model->id,$_POST['Nota_Criterio']);
                  //salva observao
                  $observacao = Avaliacao::model()->SalvaObservacao($model->id,$_POST['Avaliacao']['observacao']);
                  
                  $this->setFlashSuccesso( ($id > 0 ? 'alterar' : 'inserir') );                  
                  
                    /* se avaliao veio da visualizao do relatrio 
                     * em PDF, ento retorna para o relatrio. Caso contrrio,
                     * retorna para manifestao (caminho feliz da avaliao - que
                     * deve ser feita antes da manifestao do auditado).
                     */
                    if($_POST['visualizar_pdf']){
                        $this->redirect('../../RelatorioSaida/RelatorioSaidaAjax/'.$model->relatorio_fk."?confirma=1&visualizar_pdf=1");
                    }else{
                        $this->redirect('../../Manifestacao/ManifestacaoRelatorioAjax/'.$model->relatorio_fk."?confirma=1");
                    }
                   exit;
            }
        }

        $this->render('admin', array(
            'model' => $model,
            'titulo' => $this->titulo,
        ));
    }

    /*
    public function actionDelete($id) {
        $this->layout = false;
        if (Yii::app()->getRequest()->getIsPostRequest()) {
            $this->loadModel($id, 'Avaliacao')->delete();

             if (Yii::app()->getRequest()->getIsAjaxRequest()) {
                $this->setFlashSuccesso('excluir');
                echo  $this->getMsgSucessoHtml();
            } else {
                $this->setFlashError('excluir');
                $this->redirect(array('admin'));
            }
            
        } else
            throw new CHttpException(400, Yii::t('app', 'Sua requisio  invlida.'));
    }*/

    /*
    public function actionIndex() {
        $this->subtitulo = 'Consultar';
        $dados = null;
        $model = new Avaliacao('search');

        $model->unsetAttributes();  // clear any default values
        if (isset($_GET['Avaliacao'])) {
            $model->attributes = $_GET['Avaliacao'];
            $dados = $model->search();
        }

        $this->render('index', array(
            'model' => $model,
            'dados' => $dados,
            'titulo' => $this->titulo,
        ));
    }

    public function actionView($id) {
        $this->layout = false;
        $this->render('view', array(
                'model' => $this->loadModel($id, 'Avaliacao'),
        ));
    }
      */
     
}