<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

class RotinasCronController extends GxController {

	
	public function accessRules(){
		return array( array('allow',  // allow all users to perform 'index' and 'view' actions
                                'actions'=>array('index'),
                                'users'=>array('*'),
                         ));
	}
	

	
	
	
    // Rotinas  para colocar no Cron
    public function actionIndex() {
    	$this->layout = false;
        // rotina para verificar prazo dos 5 dias teis
        // para manifestao dos relatrios finalizados
        // (encerra somente os relatrios onde NO HOUVE,
        //  manifestao contrria)
        $rotina = Relatorio::model()->FechaPrazoRelatorioFinalizado();    
        
        // rotina para verificar se existem critrios de avaliao
        // no exerccio atual. Caso mude o ano e no haja critrios
        // de avaliao cadastrados, as Unidades Regionais no podero realizar
        // a avaliao dos auditores no momento da manifestao do relatrio.
        $rotina2 = AvaliacaoCriterio::model()->VerificaAvaliacaoCriterio();  
        
        //rotina para atualizar os feriados que se repetem todo o ano.
        //Esta rotina dever ser executada no dia 01/11 e no dia 31/12 garatindo os feriados
        //do prximo ano, pois existem processos que podem depender destas datas.
        if (((date("d") == 1) && (date("m") == 11)) || ((date("d") == 31) && (date("m") == 12))) {
            $rotina3 = Feriado::model()->AtualizaFeriadosAutomaticamente();
        }
        
        //rotina para alertar o auditado que o relatrio homologado est sem resposta por um perodo de 20 dias teis ou 60 dias corridos.
        // $rotina4 = Relatorio::model()->VerificaManifestacaoAuditado();
//         
        //rotina para alertar o auditor que o relatrio homologado est sem resposta por um perodo de 10 dias teis.
        // $rotina5 = Relatorio::model()->VerificaManifestacaoAuditor();
        
        //rotina para atualizar os processos que se repetem todo o ano.
        //Esta rotina dever ser executada no dia 01/11 e no dia 31/12 garatindo os feriados
        //do prximo ano, pois existem processos que podem depender destas datas.
        if ((date("d") == 31) && (date("m") == 12)) {
        	$rotina6 = Processo::model()->AtualizaProcessosAutomaticamente();
        }
    }


}