<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

Yii::import('application.models.table._base.BaseAvaliacaoCriterio');

class AvaliacaoCriterio extends BaseAvaliacaoCriterio
{
	public static function model($className=__CLASS__) {
		return parent::model($className);
	}
        
    public function attributeLabels() {
        $attribute_default = parent::attributeLabels();

        $attribute_custom = array(
            'id' => Yii::t('app', 'ID'),
            'numero_questao' => Yii::t('app', 'N da questo'),
            'descricao_questao' => Yii::t('app', 'Descrio da questo'),
            'valor_exercicio' => Yii::t('app', 'Exerccio'),
            
            
        );
        return array_merge($attribute_default, $attribute_custom);
    }
    
    
    // Verifica se existem critrios de avaliao cadastrados
    // para o exerccio atual. Caso no existam, envia e-mail
    // para os gerentes da Auditoria avisando.
    public function VerificaAvaliacaoCriterio(){
        $exercicio = date("Y");
        $Criterios= AvaliacaoCriterio::model()->findAllByAttributes(array('valor_exercicio'=>$exercicio));
        // se no encontrou critrios no exerccio, identifica gerentes e chefes de auditoria
        if (sizeof($Criterios)==0){
            //pega gerentes e chefes da AUDIN
            $cargo_gerente = Perfil::model()->findByAttributes(array('nome_interno'=>'SIAUDI_GERENTE'));
            $cargo_chefe = Perfil::model()->findByAttributes(array('nome_interno'=>'SIAUDI_CHEFE_AUDITORIA'));

            $gerentes = Usuario::model()->findAllByAttributes(array('perfil_fk'=>$cargo_gerente->id));
            $chefes = Usuario::model()->findAllByAttributes(array('perfil_fk'=>$cargo_chefe->id)); 
            if(is_array($gerentes)){
                foreach ($gerentes as $vetor){
                    $vetor_email[]=$vetor->nome_login;
                }
            }
            if(is_array($chefes)){
                foreach ($chefes as $vetor){
                    $vetor_email[]=$vetor->nome_login;
                }
            }                 
            // configura parmetros para enviar o e-mail
            $headers = "Reply-To: SIAUDI - CONAB <siaudi@conab.gov.br>\r\n";
            $headers .= "Return-Path: SIAUDI - CONAB <siaudi@conab.gov.br>\r\n";
            $headers .= "From: FROM SIAUDI <siaudi@conab.gov.br>\r\n";
            $headers .= "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/html;charset=iso-8859-1\r\n";
            $assunto = 'SIAUDI - Cadastrar critrios de avaliao dos auditores';

            // formata texto html
            $mensagem = "<html><head></head><body><font face='Verdana' size='2'>";
            $mensagem.= "Esta  uma mensagem automtica. O sistema SIAUDI informa que est sem ";
            $mensagem.= "critrios de avaliao dos auditores, para o exerccio de <strong>".$exercicio."</strong>.<br><br>";
            $mensagem.= " necessrio cadastrar tais critrios para que as unidades auditadas possam avaliar ";
            $mensagem.= "seus respectivos auditores. Para tanto, acesse o menu ";
            $mensagem.= " 'Configuraes -> Avaliao do Auditor -> Gerenciar Critrios de Avaliao'";
            $mensagem.= "</font></body></html>";    

            // envia e-mails            
            foreach($vetor_email as $vetor){ 
                // verifica se o e-mail j foi enviado para evitar mais 
                // de 1 envio para o mesmo destinarrio
                if(!$check_email[$vetor]){
                    $check_email[$vetor]=1;
                    $destinatario = $vetor."@conab.gov.br";
                    $ok = Relatorio::model()->Envia_email($destinatario, $assunto, $mensagem, $headers);
                }
            }
        }
    }
    
    
    /* Copia os critrios de avaliao de um ano para o outro.
     * Se o ano atual no tem critrios cadastrados, verifica
     * se o ano anterior tem, e ento, copia para o ano atual. 
     */
    public function CopiaAvaliacaoCriterio(){
        $ano_atual = date("Y");
        $ano_anterior= date("Y")-1;
        $AvaliacaoCriterio = $this->findAll('valor_exercicio='.$ano_atual);
        // se no existem critrios de avaliao no ano atual, 
        // ento  verifica se existem no ano anterior para copiar
        if(sizeof($AvaliacaoCriterio)==0){
            $AvaliacaoCriterio2 = $this->findAll('valor_exercicio='.$ano_anterior);
            // se exitem critrios no ano anterior, ento copia para o atual
            if(sizeof($AvaliacaoCriterio2)>0){
                foreach($AvaliacaoCriterio2 as $vetor){
                    $Criterio = new AvaliacaoCriterio();
                    $Criterio->descricao_questao = $vetor[descricao_questao];
                    $Criterio->valor_exercicio= $ano_atual;
                    $Criterio->numero_questao = $vetor[numero_questao];
                    $Criterio->save();
                }
            }
        }
    }
}