<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

Yii::import('application.models.table._base.BaseRisco');

class Risco extends BaseRisco
{
    public $exercicio; 
    
	public static function model($className=__CLASS__) {
		return parent::model($className);
	}
        
        // busca na tabela de riscos se
        // existe alguma ao com o exerccio passado
	public function busca_tabela($exercicio) {
                $schema = Yii::app()->params['schema'];        

                $sql = "select p.valor_exercicio from ". 
                        $schema . ".tb_risco r  LEFT JOIN ".
                        $schema .".tb_processo p ON (r.processo_fk = p.id)
                        WHERE ( p.valor_exercicio='".$exercicio."')
                        group by p.valor_exercicio";

                $command = Yii::app()->db->createCommand($sql);
                $result = $command->query();
               return ($result->readAll());
    }
        

        
        // busca nas tabelas de subriscos se
        // existe algum processo com o exerccio passado
	public function RecuperaNota($processo,$criterio) {
                $schema = Yii::app()->params['schema'];        

                // para cada critrio, pega os subcritrios e pesos
                $sql = "select id, valor_peso from ". 
                        $schema . ".tb_subcriterio
                        WHERE (criterio_fk=".$criterio.")";

                $command = Yii::app()->db->createCommand($sql);
                $result = $command->query();
                $subcriterios = $result->readAll(); 
                
                
                foreach($subcriterios as $vetor){
                    // soma os pesos do subcritrios para fazer mdia composta                    
                    $subcriterios_peso +=$vetor['valor_peso']; 
                    
                    // procura pelas notas na tabela subrisco com o subcritrio
                    $sql = "select numero_nota from ". 
                            $schema . ".tb_subrisco
                            WHERE (subcriterio_fk=".$vetor['id']." and 
                                    processo_fk =".$processo.")";     
                    $command = Yii::app()->db->createCommand($sql);
                    $result = $command->query();
                    $rs= $result->read();
                    $nota +=$rs[numero_nota]*$vetor['valor_peso'];
                }
                if ($subcriterios_peso > 0){
                	$nota = $nota /$subcriterios_peso;
                }              
               return ($nota);
    }
}