<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{acao_sureg}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "AcaoSureg".
 *
 * Columns in table "{{acao_sureg}}" available as properties of the model,
 * followed by relations of table "{{acao_sureg}}" available as properties of the model.
 *
 * @property string $unidade_administrativa_fk
 * @property string $acao_fk
 *
 * @property mixed $acaoFk
 */
abstract class BaseAcaoSureg extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{acao_sureg}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Unidade Regional por Ao|Unidades Regionais por ao', $n);
	}

	public static function representingColumn() {
		return 'unidade_administrativa_fk';
	}

	public function rules() {
		return array(
			array('unidade_administrativa_fk, acao_fk, acao_sureg', 'required'),
			array('unidade_administrativa_fk, acao_fk', 'numerical', 'integerOnly'=>true),
			array('unidade_administrativa_fk, acao_fk', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'acaoFk' => array(self::BELONGS_TO, 'acao', 'acao_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'unidade_administrativa_fk' => Yii::t('app', 'Unidade Administrativa Fk'),
			'acao_fk' => null,
			'acaoFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk, true);
		$criteria->compare('acao_fk', $this->acao_fk);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}