<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{avaliacao}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Avaliacao".
 *
 * Columns in table "{{avaliacao}}" available as properties of the model,
 * followed by relations of table "{{avaliacao}}" available as properties of the model.
 *
 * @property string $id
 * @property string $relatorio_fk
 * @property string $unidade_administrativa_fk
 * @property string $auditor_fk
 *
 * @property mixed $relatorioFk
 * @property mixed $auditorFk
 */
abstract class BaseAvaliacao extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{avaliacao}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Avaliao|Avaliaes', $n);
	}

	public static function representingColumn() {
		return 'id';
	}

	public function rules() {
		return array(
			array('id, relatorio_fk, unidade_administrativa_fk, usuario_fk, date, nome_login', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'relatorioFk' => array(self::BELONGS_TO, 'Relatorio', 'relatorio_fk'),
			'usuarioFk' => array(self::BELONGS_TO, 'Usuario', 'usuario_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'relatorio_fk' => null,
			'unidade_administrativa_fk' => Yii::t('app', 'Unidade Administrativa Fk'),
			'usuario_fk' => null,
			'relatorioFk' => null,
			'usuarioFk' => null,
                        'observacao' => Yii::t('app', 'Observao'),
                        'data' => null,
                        'nome_login' => null,
                        'valor_exercicio' => Yii::t('app', 'Exerccio'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;
		$criteria->compare('id', $this->id, true);
		$criteria->compare('relatorio_fk', $this->relatorio_fk);
		$criteria->compare('unidade_administrativa_fk', $this->unidade_administrativa_fk, true);
		$criteria->compare('usuario_fk', $this->usuario_fk);
                $criteria->compare('data', $this->data);
                $criteria->compare('nome_login', $this->nome_login);
		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}