<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{avaliacao_criterio}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "AvaliacaoCriterio".
 *
 * Columns in table "{{avaliacao_criterio}}" available as properties of the model,
 * and there are no model relations.
 *
 * @property string $id
 * @property string $descricao_questao
 * @property integer $valor_exercicio
 *
 */
abstract class BaseAvaliacaoCriterio extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{avaliacao_criterio}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Critrio da Avaliao|Critrios da Avaliao', $n);
	}

	public static function representingColumn() {
		return 'descricao_questao';
	}

	public function rules() {
		return array(
			array('descricao_questao, valor_exercicio, numero_questao', 'required'),
			array('valor_exercicio, numero_questao', 'numerical', 'integerOnly'=>true),
			array('descricao_questao', 'length', 'max'=>500),
			array('id, descricao_questao, valor_exercicio, numero_questao', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'descricao_questao' => Yii::t('app', 'Nome Criterio'),
			'valor_exercicio' => Yii::t('app', 'Valor Exercicio'),
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
                if ($this->descricao_questao){
                        $criteria->condition="descricao_questao ilike :input";
                        $criteria->params=array(":input"=>"%".$this->descricao_questao."%");
                }                
		$criteria->compare('valor_exercicio', $this->valor_exercicio);
		$criteria->compare('numero_questao', $this->numero_questao);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}