<?php
/********************************************************************************
*  Copyright 2015 Conab - Companhia Nacional de Abastecimento                   *
*                                                                               *
*  Este arquivo  parte do Sistema SIAUDI.                                      *
*                                                                               *
*  SIAUDI   um software livre; voc pode redistribui-lo e/ou                   *
*  modific-lo sob os termos da Licena Pblica Geral GNU conforme              *
*  publicada pela Free Software Foundation; tanto a verso 2 da                 *
*  Licena, como (a seu critrio) qualquer verso posterior.                    *
*                                                                               *
*  SIAUDI  distribudo na expectativa de que seja til,                        *
*  porm, SEM NENHUMA GARANTIA; nem mesmo a garantia implcita                  *
*  de COMERCIABILIDADE OU ADEQUAO A UMA FINALIDADE ESPECFICA.                *
*  Consulte a Licena Pblica Geral do GNU para mais detalhes em portugus:     *
*  http://creativecommons.org/licenses/GPL/2.0/legalcode.pt                     *
*                                                                               *
*  Voc deve ter recebido uma cpia da Licena Pblica Geral do GNU             *
*  junto com este programa; se no, escreva para a Free Software                *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA    *
*                                                                               *
*  Sistema   : SIAUDI - Sistema de Auditoria Interna                            *
*  Data      : 05/2015                                                          *
*                                                                               *
********************************************************************************/
?>
<?php

/**
 * This is the model base class for the table "{{criterio}}".
 * DO NOT MODIFY THIS FILE! It is automatically generated by giix.
 * If any changes are necessary, you must set or override the required
 * property or method in class "Criterio".
 *
 * Columns in table "{{criterio}}" available as properties of the model,
 * followed by relations of table "{{criterio}}" available as properties of the model.
 *
 * @property string $id
 * @property integer $valor_exercicio
 * @property string $nome_criterio
 * @property string $tipo_criterio_fk
 * @property integer $valor_peso
 *
 * @property mixed $tipoCriterioFk
 */
abstract class BaseCriterio extends GxActiveRecord {

	public static function model($className=__CLASS__) {
		return parent::model($className);
	}

	public function tableName() {
		return '{{criterio}}';
	}

	public static function label($n = 1) {
		return Yii::t('app', 'Critrio|Critrios', $n);
	}

	public static function representingColumn() {
		return 'nome_criterio';
	}

	public function rules() {
		return array(
			array('valor_exercicio, nome_criterio, tipo_criterio_fk, valor_peso, descricao_criterio', 'required'),
			array('valor_exercicio, valor_peso', 'numerical', 'integerOnly'=>true),
			array('nome_criterio', 'length', 'max'=>200),
			array('tipo_criterio_fk, valor_peso', 'numerical', 'integerOnly'=>true),
			array('id, valor_exercicio, nome_criterio, tipo_criterio_fk, valor_peso,  descricao_criterio', 'safe', 'on'=>'search'),
		);
	}

	public function relations() {
		return array(
			'tipoCriterioFk' => array(self::BELONGS_TO, 'TipoCriterio', 'tipo_criterio_fk'),
		);
	}

	public function pivotModels() {
		return array(
		);
	}

	public function attributeLabels() {
		return array(
			'id' => Yii::t('app', 'ID'),
			'valor_exercicio' => Yii::t('app', 'Valor Exercicio'),
			'nome_criterio' => Yii::t('app', 'Nome Criterio'),
			'tipo_criterio_fk' => null,
			'valor_peso' => Yii::t('app', 'Valor Peso'),
			'descricao_criterio' => Yii::t('app', 'Descrio'),                    
			'tipoCriterioFk' => null,
		);
	}

	public function search() {
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id, true);
		$criteria->compare('valor_exercicio', $this->valor_exercicio);
		$criteria->compare('nome_criterio', $this->nome_criterio, true);
		$criteria->compare('tipo_criterio_fk', $this->tipo_criterio_fk);
		$criteria->compare('valor_peso', $this->valor_peso);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}
}